<?php
// Unitoreios - show UDID result by id (IDREQ)
declare(strict_types=1);
error_reporting(0);
ini_set('display_errors','0');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');
header('X-Unitoreios-UDIDResult: v22');

$id = $_GET['id'] ?? '';
$id = is_string($id) ? preg_replace('/[^a-zA-Z0-9\-_]/', '', trim($id)) : '';
if ($id === '') {
  http_response_code(400);
  header('Content-Type: text/plain; charset=utf-8');
  exit("Thiếu id\n");
}

define('UNITOREIOS_SILENT_DB', false);
require_once __DIR__ . '/layouts/config.php';

header('Content-Type: application/json; charset=utf-8');
$out = ['ok'=>true,'id'=>$id,'found'=>false];

if (!isset($conn) || !($conn instanceof mysqli)) {
  $out['ok']=false;
  $out['error']='DB not connected';
  echo json_encode($out, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES);
  exit;
}

$stmt = $conn->prepare("SELECT UDID, PRODUCT, VERSION, DEVICE_NAME, devicekey, created_at FROM devices WHERE IDREQ = ? ORDER BY created_at DESC LIMIT 1");
if ($stmt) {
  $stmt->bind_param("s", $id);
  $stmt->execute();
  $res = $stmt->get_result();
  if ($res && ($row = $res->fetch_assoc())) {
    $out['found']=true;
    $out['device']=$row;
  }
  $stmt->close();
}
echo json_encode($out, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES);
