<?php
// Unitoreios - tail udid_debug.log for troubleshooting iOS Profile Service callbacks
declare(strict_types=1);

error_reporting(0);
ini_set('display_errors','0');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');
header('X-Unitoreios-DebugTail: v22');

$log = __DIR__ . '/udid_debug.log';
$lines = isset($_GET['lines']) ? intval($_GET['lines']) : 50;
if ($lines < 1) $lines = 50;
if ($lines > 300) $lines = 300;

$format = strtolower((string)($_GET['format'] ?? 'text'));

if (!is_file($log)) {
  if ($format === 'json') {
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode(['ok'=>false,'message'=>'udid_debug.log not found'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES);
  } else {
    header('Content-Type: text/plain; charset=utf-8');
    echo "udid_debug.log not found\n";
  }
  exit;
}

$data = @file($log, FILE_IGNORE_NEW_LINES);
if (!is_array($data)) $data = [];
$tail = array_slice($data, -$lines);

if ($format === 'json') {
  header('Content-Type: application/json; charset=utf-8');
  echo json_encode(['ok'=>true,'lines'=>count($tail),'data'=>$tail], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES);
} else {
  header('Content-Type: text/plain; charset=utf-8');
  echo implode("\n", $tail) . "\n";
}
