<?php
require_once('layouts/config.php');
include 'layouts/session.php';
$username = $_SESSION["username"];

// Lấy số tiền hiện tại của người dùng
$sqlMoney = "SELECT `money` FROM `tai_khoan` WHERE `username` = ?";
$stmtMoney = $conn->prepare($sqlMoney);
$stmtMoney->bind_param("s", $username);
$stmtMoney->execute();
$resultMoney = $stmtMoney->get_result();
$rowMoney = $resultMoney->fetch_assoc();
$currentMoney = $rowMoney['money'] ?? 0;

// Giá tiền nâng cấp
$upgradeCost = 50000;

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['upgrade']) && $_POST['upgrade'] === 'true') {
    // Xử lý yêu cầu nâng cấp bằng AJAX
    $sqlCheckVIP = "SELECT `quyen` FROM `tai_khoan` WHERE `username` = ?";
    $stmtCheckVIP = $conn->prepare($sqlCheckVIP);
    $stmtCheckVIP->bind_param("s", $username);
    $stmtCheckVIP->execute();
    $resultCheckVIP = $stmtCheckVIP->get_result();
    $rowCheckVIP = $resultCheckVIP->fetch_assoc();

    if ($rowCheckVIP && $rowCheckVIP['quyen'] == 2) {
        // User is already VIP, send error response
        echo json_encode(['error' => 1, 'message' => 'Bạn đã là VIP.']);
        exit;
    }
    
    if ($rowCheckVIP && $rowCheckVIP['quyen'] == 1) {
        // User is already VIP, send error response
        echo json_encode(['error' => 1, 'message' => 'Bạn đã là ADMIN.']);
        exit;
    }

    if ($currentMoney >= $upgradeCost) {
        // Trừ tiền từ tài khoản
        $datecount = 30; // Number of days to add to the current date
        $date = date('Y-m-d H:i:s', strtotime('+' . $datecount . ' days')); // Calculate the new date after adding $datecount days
        
        $newMoney = $currentMoney - $upgradeCost; // Calculate new money after deducting upgrade cost
        
        $sqlUpdate = "UPDATE `tai_khoan` SET `money` = ?, `date` = ?, `quyen` = 2, `keylimit` = 100, `package_limit` = 5, `uuid_limit` = 100 WHERE `username` = ?";
        $stmtUpdate = $conn->prepare($sqlUpdate);
        
        // Bind parameters and execute the statement
        $stmtUpdate->bind_param("iss", $newMoney, $date, $username); // 'iss' indicates three parameters: integer, string, string
        $stmtUpdate->execute();


        if ($stmtUpdate->execute()) {
            // Nâng cấp thành công
            echo json_encode(['error' => 0, 'message' => 'Nâng cấp tài khoản thành công!']);
        } else {
            echo json_encode(['error' => 1, 'message' => 'Lỗi: ' . $stmtUpdate->error]);
        }
    } else {
        echo json_encode(['error' => 1, 'message' => 'Số dư không đủ để nâng cấp!']);
    }

    exit; // Dừng xử lý PHP sau khi xử lý AJAX
} 
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Nâng Cấp Tài Khoản | Unitoreios API Unitoreios</title>
    <?php include 'layouts/head.php'; ?>
    <?php include 'layouts/head-style.php'; ?>
</head>
<body class="<?php echo $theme; ?>">
<?php include 'layouts/menu.php'; ?>

<div class="main-content">
    <div class="page-content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-xl-12">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">Nâng cấp tài khoản</h4>
                            <p class="card-title-desc">Sử dụng bản trả phí là một cách ủng hộ tôi và nâng cấp quyền lợi của bạn.</p>
                        </div>
                        <div class="card-body">
                            <div class="row justify-content-center"> 
                                <div class="col-xl-6"> 
                                    <div class="text-center plan-shadow">
                                        <div class="pricing-card">
                                            <h3 class="plan-name">Gói VIP</h3>
                                            <p class="plan-cost">100.000 VND <span>/ Tháng</span></p>
                                            <ul class="plan-features">
                                                <li><i class="mdi mdi-check text-success me-2"></i> Tùy chỉnh name Key 1 lần (ví dụ: <?php echo $username; ?>-xxxxx)</li>
                                                <li><i class="mdi mdi-check text-success me-2"></i> Mở khóa giới hạn 5 Package</li>
                                                <li><i class="mdi mdi-check text-success me-2"></i> Mở khóa giới hạn 100 Key</li>
                                                <li><i class="mdi mdi-check text-success me-2"></i> 100 UUID cho mỗi Key</li>
                                                <li><i class="mdi mdi-check text-success me-2"></i> Hỗ trợ Make app riêng (liên hệ)</li>
                                            </ul>
                                            <button onclick="upgradeAccount()" class="btn btn-primary btn-rounded">Nâng cấp ngay</button>
                                        </div>
                                    </div> 
                                </div> <!-- end col -->
                            </div> <!-- end row -->
                        </div>
                    </div>
                </div>
            </div> 
        </div>
    </div> 
</div>
<?php include 'layouts/right-sidebar.php'; ?>
<!-- /Right-bar -->

<!-- JAVASCRIPT -->

<?php include 'layouts/vendor-scripts.php'; ?>

<script src="assets/js/app.js"></script>
<script src="https://code.jquery.com/jquery-3.3.1.min.js"></script> 
<script>
function upgradeAccount() {
    Swal.fire({
        title: 'Xác nhận nâng cấp?',
        text: "Bạn có chắc chắn muốn nâng cấp tài khoản?",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Xác nhận',
        cancelButtonText: 'Hủy'
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                type: 'POST',
                url: '', // Gửi yêu cầu đến chính trang này
                data: { upgrade: 'true' }, 
                dataType: 'json',
                success: function(response) {
                    if (response.error == 0) {
                        Swal.fire({
                            title: 'Thành công!',
                            text: response.message + '  Bạn sẽ được đăng xuất.',
                            icon: 'success',
                            timer: 3000, 
                            timerProgressBar: true,
                            showConfirmButton: false 
                        }).then(() => {
                            window.location.href = 'logout.php';
                        });
                    } else {
                        Swal.fire({
                            title: 'Lỗi!',
                            text: response.message,
                            icon: 'error'
                        });
                    }
                },
                error: function() {
                    Swal.fire({
                        title: 'Lỗi!',
                        text: 'Đã có lỗi xảy ra. Vui lòng thử lại sau.',
                        icon: 'error'
                    });
                }
            });
        }
    })
}
</script>


<?php include 'layouts/footer.php'; ?>
</body>
</html>