<?php
// Unitoreios: route controller for create package (Admin/User)
// IMPORTANT: use *_once to avoid function redeclare fatals (blank page)
require_once __DIR__ . '/layouts/session.php';

$email = $_SESSION['email'] ?? null;

// Determine role
$stmt = mysqli_prepare($conn, "SELECT quyen FROM tai_khoan WHERE email = ? LIMIT 1");
mysqli_stmt_bind_param($stmt, "s", $email);
mysqli_stmt_execute($stmt);
$row = u_stmt_fetch_assoc($stmt);
mysqli_stmt_close($stmt);

$role = isset($row['quyen']) ? intval($row['quyen']) : 0;

if ($role === 1) {
    // Admin flow
    include __DIR__ . '/create-package.php';
    exit;
}

// User flow
include __DIR__ . '/create-package-user.php';
exit;
?>