<?php 
    $subject = "This is my UDID from iOS device";
    $body  = "Hello Unitoreios,
    This is my UDID: {$_GET['UDID']}
    ";
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta content="width=device-width, initial-scale=1.0" name="viewport">
<title>Thông Tin Thiết Bị</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/11.0.10/sweetalert2.min.css">
<link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i|Raleway:300,300i,400,400i,500,500i,600,600i,700,700i|Poppins:300,300i,400,400i,500,500i,600,600i,700,700i" rel="stylesheet">

<link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/css/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-icons/1.10.5/font/bootstrap-icons.min.css">


<style>
body {
  font-family: "Open Sans", sans-serif;
  color: #444444;
}

a {
  text-decoration: none;
  color: #5a5af3;
}

a:hover {
  color: #2a2af0;
  text-decoration: none;
}

h1,
h2,
h3,
h4,
h5,
h6 {
  font-family: "Raleway", sans-serif;
}

/*--------------------------------------------------------------
# Header
--------------------------------------------------------------*/
#header {
  transition: all 0.5s;
  z-index: 997;
  padding: 20px 0;
  background: #fff;
}

#header.header-scrolled,
#header.header-inner-pages {
  padding: 12px 0;
  box-shadow: 0px 2px 15px rgba(0, 0, 0, 0.1);
}

#header .logo {
  font-size: 32px;
  margin: 0;
  padding: 0;
  line-height: 1;
  font-weight: 700;
  letter-spacing: 2px;
  font-family: "Poppins", sans-serif;
}

#header .logo a {
  color: #5a5af3;
}

#header .logo img {
  max-height: 40px;
}

@media (max-width: 992px) {
  #header {
    padding: 12px 0;
  }
}

/*--------------------------------------------------------------
# Hero Section
--------------------------------------------------------------*/
#hero {
  width: 100%;
  height: 100vh;
  background: white;
  border-bottom: 2px solid white;
}

#hero .container {
  padding-top: 80px;
}

#hero h1 {
  margin: 0;
  font-size: 48px;
  font-weight: 400;
  line-height: 56px;
  color: #434175;
  font-family: "Poppins", sans-serif;
}

#hero h2 {
  margin: 10px 0 0 0;
  font-size: 20px;
}

#hero ul {
  margin-top: 15px;
  list-style: none;
  padding: 0;
}

#hero ul li {
  padding: 10px 0 0 28px;
  position: relative;
}

#hero ul i {
  left: 0;
  top: 7px;
  position: absolute;
  font-size: 20px;
  color: #5a5af3;
}

#hero .btn-get-started,
#hero .btn-get-quote {
  font-family: "Poppins", sans-serif;
  font-weight: 400;
  font-size: 15px;
  letter-spacing: 0.5px;
  display: inline-block;
  padding: 8px 30px 9px 30px;
  margin-bottom: 15px;
  border-radius: 3px;
  transition: 0.5s;
  border-radius: 50px;
}

#hero .btn-get-started {
  background: #5a5af3;
  color: #fff;
  border: 2px solid #5a5af3;
  margin-right: 10px;
}

#hero .btn-get-started:hover {
  background: #7272f5;
  border-color: #7272f5;
}

#hero .btn-get-quote {
  color: #5a5af3;
  border: 2px solid #5a5af3;
}

#hero .btn-get-quote:hover {
  background: #5a5af3;
  color: #fff;
}

@media (min-width: 1024px) {
  #hero {
    background-attachment: fixed;
  }
}

@media (max-width: 991px) {
  #hero .hero-img {
    text-align: center;
  }

  #hero .hero-img img {
    width: 50%;
  }
}

@media (max-width: 768px) {
  #hero h1 {
    font-size: 28px;
    line-height: 36px;
  }

  #hero h2 {
    font-size: 18px;
    line-height: 24px;
    margin-bottom: 30px;
  }

  #hero .hero-img img {
    width: 70%;
  }
}

@media (max-width: 575px) {
  #hero {
    text-align: center;
  }

  #hero ul {
    text-align: left;
    font-size: 14px;
  }

  #hero .hero-img img {
    width: 80%;
  }

  #hero .btn-get-started,
  #hero .btn-get-quote {
    padding-left: 18px;
    padding-right: 18px;
    font-size: 14px;
  }
}

/*--------------------------------------------------------------
# Sections General
--------------------------------------------------------------*/
section {
  padding: 60px 0;
}

.section-bg {
  background-color: #eeeef5;
}

.section-title {
  text-align: center;
  padding-bottom: 30px;
}

.section-title h2 {
  font-size: 32px;
  font-weight: bold;
  text-transform: uppercase;
  margin-bottom: 20px;
  padding-bottom: 20px;
  position: relative;
  color: #434175;
}

.section-title h2::after {
  content: "";
  position: absolute;
  display: block;
  width: 50px;
  height: 3px;
  background: #5a5af3;
  bottom: 0;
  left: calc(50% - 25px);
}

.section-title p {
  margin-bottom: 0;
}

/*--------------------------------------------------------------
# Frequently Asked Questions
--------------------------------------------------------------*/
.faq {
  padding: 60px 0;
}

.faq .faq-list {
  padding: 0;
  list-style: none;
}

.faq .faq-list li {
  border-bottom: 1px solid #f2f2fe;
  margin-bottom: 20px;
  padding-bottom: 20px;
}

.faq .faq-list .question {
  display: block;
  position: relative;
  font-family: #5a5af3;
  font-size: 18px;
  line-height: 24px;
  font-weight: 400;
  padding-left: 25px;
  cursor: pointer;
  color: #2a2af0;
  transition: 0.3s;
}

.faq .faq-list i {
  font-size: 16px;
  position: absolute;
  left: 0;
  top: -2px;
}

.faq .faq-list p {
  margin-bottom: 0;
  padding: 10px 0 0 25px;
}

.faq .faq-list .icon-show {
  display: none;
}

.faq .faq-list .collapsed {
  color: black;
}

.faq .faq-list .collapsed:hover {
  color: #5a5af3;
}

.faq .faq-list .collapsed .icon-show {
  display: inline-block;
  transition: 0.6s;
}

.faq .faq-list .collapsed .icon-close {
  display: none;
  transition: 0.6s;
}

/*--------------------------------------------------------------
# Footer
--------------------------------------------------------------*/
#footer {
  color: #444444;
  font-size: 14px;
  background: #eeeef5;
  box-shadow: 0px 2px 15px rgba(0, 0, 0, 0.1);
}

#footer .footer-top {
  padding: 60px 0 30px 0;
  background: #fff;
}

#footer .footer-top .footer-contact {
  margin-bottom: 30px;
}

#footer .footer-top .footer-contact h3 {
  font-size: 28px;
  margin: 0 0 10px 0;
  padding: 0;
  line-height: 1;
  font-weight: 700;
  color: #5a5af3;
}

#footer .footer-top .footer-contact p {
  font-size: 14px;
  line-height: 24px;
  margin-bottom: 0;
  font-family: "Raleway", sans-serif;
  color: #777777;
}

#footer .footer-top h4 {
  font-size: 16px;
  font-weight: bold;
  color: #434175;
  position: relative;
  padding-bottom: 12px;
}

#footer .footer-top .footer-links {
  margin-bottom: 30px;
}

#footer .footer-top .footer-links ul {
  list-style: none;
  padding: 0;
  margin: 0;
}

#footer .footer-top .footer-links ul i {
  padding-right: 2px;
  color: #5a5af3;
  font-size: 18px;
  line-height: 1;
}

#footer .footer-top .footer-links ul li {
  padding: 10px 0;
  display: flex;
  align-items: center;
}

#footer .footer-top .footer-links ul li:first-child {
  padding-top: 0;
}

#footer .footer-top .footer-links ul a {
  color: #777777;
  transition: 0.3s;
  display: inline-block;
  line-height: 1;
}

#footer .footer-top .footer-links ul a:hover {
  text-decoration: none;
  color: #5a5af3;
}

#footer .footer-newsletter {
  font-size: 15px;
}

#footer .footer-newsletter h4 {
  font-size: 16px;
  font-weight: bold;
  color: #444444;
  position: relative;
  padding-bottom: 12px;
}

#footer .footer-newsletter form {
  margin-top: 30px;
  background: #fff;
  padding: 6px 10px;
  position: relative;
  border-radius: 50px;
  text-align: left;
  border: 1px solid #b9b9fa;
}

#footer .footer-newsletter form input[type="email"] {
  border: 0;
  padding: 4px 8px;
  width: calc(100% - 100px);
}

#footer .footer-newsletter form input[type="submit"] {
  position: absolute;
  top: -1px;
  right: -1px;
  bottom: -1px;
  border: 0;
  background: none;
  font-size: 16px;
  padding: 0 20px;
  background: #5a5af3;
  color: #fff;
  transition: 0.3s;
  border-radius: 50px;
  box-shadow: 0px 2px 15px rgba(0, 0, 0, 0.1);
}

#footer .footer-newsletter form input[type="submit"]:hover {
  background: #7272f5;
}

#footer .credits {
  padding-top: 5px;
  font-size: 13px;
  color: #444444;
}

#footer .credits a {
  transition: 0.3s;
}

#footer .social-links a {
  font-size: 18px;
  display: inline-block;
  background: #deddec;
  color: #434175;
  line-height: 1;
  padding: 8px 0;
  margin-right: 4px;
  border-radius: 50%;
  text-align: center;
  width: 36px;
  height: 36px;
  transition: 0.3s;
}

#footer .social-links a:hover {
  background: #5a5af3;
  color: #fff;
  text-decoration: none;
}
</style>
</head>
<body>

<header id="header" class="fixed-top ">
<div class="container d-flex align-items-center justify-content-between">
<h1 class="logo"><a href="#">Unitoreios SERVER</a></h1>
</div>
</header>

<section id="hero" class="d-flex align-items-center">
<div class="container">
<div class="row">
<div class="col-lg-12 pt-2 pt-lg-0 order-2 order-lg-1 d-flex flex-column justify-content-center">
<h1>Thông Tin Thiết Bị Của Bạn Là</h1>
<ul>
    <li>UDID: <?php echo $_GET['UDID']; ?></li>
</ul>

<p class="mt-3">Nếu muốn thuê server hoặc các vấn đề khác gửi mail cho tôi</p>
<div class="mt-3">
    <a href="mailto:edmkingx11@gmail.com?subject=<?php echo $subject ?>&body=<?php echo $body?>" class="btn-get-started">Gửi mail</a>
</div>
</div>
</div>
</div>
</section>

<footer id="footer">
<div class="container d-md-flex py-4">
<div class="me-md-auto text-center text-md-start">
<div class="copyright">
© Copyright <strong><span>Unitoreios API</span></strong>. All Rights Reserved
</div>
</div>
<div class="social-links text-center text-md-right pt-3 pt-md-0">
<a href="https://t.me/unitoreios" target="_blank" class="twitter"><i class="bi bi-github"></i></a>
<a href="https://apiunitoreios.site/Apiunitoreios/dashboard" target="_blank" class="facebook"><i class="bi bi-facebook"></i></a>
<a href="https://t.me/APIserie" target="_blank" class="linkedin"><i class="bi bi-telegram"></i></a>
</div>
</div>
</footer>

<script src="https://code.jquery.com/jquery-3.6.4.min.js" integrity="sha256-oP6HI9z1XaZNBrJURtCoUT5SUnxFr8s3BzRl+cbzUq8=" crossorigin="anonymous"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/js/bootstrap.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/11.0.10/sweetalert2.min.js"></script>

</body>
</html>