<?php
session_start();
require_once("../layouts/config.php");

if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true || empty($_SESSION['email'])) {
    die(json_encode(['error' => 1, 'msg' => 'Bạn chưa đăng nhập.']));
}

$email = $_SESSION['email'];
$username = $_SESSION['username'] ?? '';

$return = ['error' => 0];

$type = $_REQUEST['type'] ?? '';

/**
 * Fetch account role & quota
 */
$stmt = mysqli_prepare($conn, "SELECT quyen, package_limit FROM tai_khoan WHERE email = ? LIMIT 1");
mysqli_stmt_bind_param($stmt, "s", $email);
mysqli_stmt_execute($stmt);
$acc = u_stmt_fetch_assoc($stmt) ?: ['quyen' => 0, 'package_limit' => 0];
mysqli_stmt_close($stmt);

$role = intval($acc['quyen'] ?? 0);
$package_limit = intval($acc['package_limit'] ?? 0);

/**
 * Helpers
 */
function json_die($arr) {
    die(json_encode($arr));
}

function ensure_owner_or_admin($conn, $email, $role, $package_id) {
    if ($role === 1) return true;
    $stmt = mysqli_prepare($conn, "SELECT email FROM package WHERE id = ? LIMIT 1");
    mysqli_stmt_bind_param($stmt, "i", $package_id);
    mysqli_stmt_execute($stmt);
    $row = u_stmt_fetch_assoc($stmt);
    mysqli_stmt_close($stmt);
    if (!$row) return false;
    return ($row['email'] === $email);
}

// ====== DELETE ======
if ($type === 'delpackage') {
    $id = intval($_POST['package_id'] ?? 0);
    if ($id <= 0) json_die(['error'=>1,'msg'=>'Thiếu package_id']);

    if (!ensure_owner_or_admin($conn, $email, $role, $id)) {
        json_die(['error'=>1,'msg'=>'Bạn không có quyền xoá package này.']);
    }

    if (mysqli_query($conn, "DELETE FROM package WHERE id = '$id'")) {
        json_die(['error'=>0,'msg'=>"Bạn đã xoá package có id $id thành công."]);
    }
    json_die(['error'=>1,'msg'=>'Xoá package thất bại.']);
}

// ====== LOCK/UNLOCK ======
if ($type === 'lockpackage' || $type === 'unlockpackage') {
    $id = intval($_POST['package_id'] ?? 0);
    if ($id <= 0) json_die(['error'=>1,'msg'=>'Thiếu package_id']);

    if (!ensure_owner_or_admin($conn, $email, $role, $id)) {
        json_die(['error'=>1,'msg'=>'Bạn không có quyền thao tác package này.']);
    }

    $status = ($type === 'lockpackage') ? '2' : '1';
    if (mysqli_query($conn, "UPDATE package SET debstatus='$status' WHERE id = '$id'")) {
        json_die(['error'=>0,'msg'=> $type === 'lockpackage' ? 'Package đã đang trong trạng thái bảo trì !' : 'Package đã hoạt động trở lại !']);
    }
    json_die(['error'=>1,'msg'=>'Thao tác thất bại.']);
}

// ====== CHECK ON/OFF ======
if ($type === 'offcheck' || $type === 'oncheck') {
    $id = intval($_POST['package_id'] ?? 0);
    if ($id <= 0) json_die(['error'=>1,'msg'=>'Thiếu package_id']);

    if (!ensure_owner_or_admin($conn, $email, $role, $id)) {
        json_die(['error'=>1,'msg'=>'Bạn không có quyền thao tác package này.']);
    }

    $val = ($type === 'oncheck') ? '1' : '0';
    if (mysqli_query($conn, "UPDATE package SET hashcheck ='$val' WHERE id = '$id'")) {
        json_die(['error'=>0,'msg'=> $type === 'oncheck' ? 'Đã bật kiểm tra tài nguyên !' : 'Đã tắt kiểm tra tài nguyên !']);
    }
    json_die(['error'=>1,'msg'=>'Thao tác thất bại.']);
}

// ====== CHANGE SHA1 ======
if ($type === 'changesha1') {
    $id = intval($_POST['package_id'] ?? 0);
    $package_sha1 = md5(strtolower(trim($_POST['package_sha1'] ?? '')));
    if ($id <= 0 || !$package_sha1) json_die(['error'=>1,'msg'=>'Thiếu dữ liệu.']);

    if (!ensure_owner_or_admin($conn, $email, $role, $id)) {
        json_die(['error'=>1,'msg'=>'Bạn không có quyền thao tác package này.']);
    }

    if (mysqli_query($conn, "UPDATE package SET debhash = '$package_sha1' WHERE id = '$id'")) {
        json_die(['error'=>0,'msg'=>'Cập nhật SHA1 thành công.']);
    }
    json_die(['error'=>1,'msg'=>'Cập nhật SHA1 thất bại.']);
}

// ====== CREATE PACKAGE (Admin + User theo quota) ======
if ($type === 'creatpackage') {
    // Quota check for user
    if ($role !== 1) {
        // remaining = package_limit - number of packages created
        $res_cnt = mysqli_query($conn, "SELECT COUNT(id) AS cnt FROM package WHERE email = '".mysqli_real_escape_string($conn,$email)."'");
        $row_cnt = mysqli_fetch_assoc($res_cnt);
        $created_cnt = intval($row_cnt['cnt'] ?? 0);

        $remaining = $package_limit - $created_cnt;
        if ($package_limit < 0) $remaining = 999999; // unlimited
        if ($remaining <= 0) {
            json_die(['error'=>1,'msg'=>'Bạn đã hết lượt tạo package. Vui lòng nâng cấp/gia hạn để mở thêm.']);
        }
    }

    $deb_name = trim($_POST['package_name'] ?? '');
    $deb_ver = trim($_POST['package_version'] ?? '');
    $deb_sha1_raw = strtolower(trim($_POST['package_sha1'] ?? ''));
    $deb_hash = md5($deb_sha1_raw);
    $deb_color = trim($_POST['package_color'] ?? '');
    $deb_new = trim($_POST['package_newlink'] ?? '');
    $deb_profile = trim($_POST['package_profile'] ?? '');
    $deb_changelog = trim($_POST['package_changelog'] ?? '');
    $deb_status = trim($_POST['package_status'] ?? '1');
    $statusUDID = isset($_POST['status_udid']) ? trim($_POST['status_udid']) : "1";

    if ($deb_name === '') json_die(['error'=>1,'msg'=>'Tên package không được để trống.']);

    $debhash = $username . "-" . substr(str_shuffle("0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"), 0, 32) . "-" . $deb_hash;

    $stmt = $conn->prepare("INSERT INTO package (debname, debversion, email, debstatus, debupdatenoti, newdeblink, debcontact, debhash, colorcode, statusUDID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("ssssssssss", $deb_name, $deb_ver, $email, $deb_status, $deb_changelog, $deb_new, $deb_profile, $debhash, $deb_color, $statusUDID);

    if ($stmt->execute()) {
        $stmt->close();
        json_die(['error'=>0,'msg'=>'Khởi tạo thành công.']);
    }

    $stmt->close();
    json_die(['error'=>1,'msg'=>'Đã xảy ra lỗi khi khởi tạo, vui lòng thử lại sau.']);
}

// ====== UPDATE PACKAGE ======
if ($type === 'updatepackage') {
    $id = intval($_POST['package_id'] ?? 0);
    if ($id <= 0) json_die(['error'=>1,'msg'=>'Thiếu package_id']);

    if (!ensure_owner_or_admin($conn, $email, $role, $id)) {
        json_die(['error'=>1,'msg'=>'Bạn không có quyền cập nhật package này.']);
    }

    $deb_name = $_POST['package_name'] ?? '';
    $deb_ver = $_POST['package_version'] ?? '';
    $deb_color = $_POST['package_color'] ?? '';
    $deb_new = $_POST['package_newlink'] ?? '';
    $deb_profile = $_POST['package_profile'] ?? '';
    $deb_changelog = $_POST['package_changelog'] ?? '';
    $debstatus = isset($_POST['package_status']) ? $_POST['package_status'] : null;
    $statusUDID = isset($_POST['status_udid']) ? $_POST['status_udid'] : $debstatus;

    $query = "UPDATE package SET 
                debname = '".mysqli_real_escape_string($conn,$deb_name)."',
                debversion = '".mysqli_real_escape_string($conn,$deb_ver)."',
                debupdatenoti = '".mysqli_real_escape_string($conn,$deb_changelog)."',
                newdeblink = '".mysqli_real_escape_string($conn,$deb_new)."',
                debcontact = '".mysqli_real_escape_string($conn,$deb_profile)."',
                colorcode = '".mysqli_real_escape_string($conn,$deb_color)."',
                debstatus = '".mysqli_real_escape_string($conn,$debstatus)."',
                statusUDID = '".mysqli_real_escape_string($conn,$statusUDID)."'
              WHERE id = $id";

    if (mysqli_query($conn, $query)) {
        json_die(['error'=>0,'msg'=>'Cập nhật thành công.']);
    }
    json_die(['error'=>1,'msg'=>'Đã xảy ra lỗi khi cập nhật, vui lòng thử lại sau.']);
}

// ====== UPDATE MOD LINK ======
if ($type === 'updatepackage1') {
    $id = intval($_POST['package_id'] ?? 0);
    if ($id <= 0) json_die(['error'=>1,'msg'=>'Thiếu package_id']);

    if (!ensure_owner_or_admin($conn, $email, $role, $id)) {
        json_die(['error'=>1,'msg'=>'Bạn không có quyền cập nhật package này.']);
    }

    $deb_name = $_POST['package_name'] ?? '';
    $deb_mod = $_POST['package_mod'] ?? '';

    $q = "UPDATE package SET 
        debname = '".mysqli_real_escape_string($conn,$deb_name)."',
        linkmod = '".mysqli_real_escape_string($conn,$deb_mod)."'
        WHERE id = $id";
    if (mysqli_query($conn, $q)) {
        json_die(['error'=>0,'msg'=>'Cập nhật thành công.']);
    }
    json_die(['error'=>1,'msg'=>'Đã xảy ra lỗi khi cập nhật, vui lòng thử lại sau.']);
}

// ====== TOKEN ======
if ($type === 'gettoken') {
    json_die(['token' => $_SESSION['token'] ?? null]);
}

json_die(['error'=>1,'msg'=>'Hành động không hợp lệ.']);
?>