<?php

// connect database
require_once("../layouts/session.php");
$email = $_SESSION['email'];
if ($_REQUEST) {
    $return = array(
        'error' => 0
    );
    $check_quyen_sql = "SELECT quyen,keylimit,uuid_limit FROM tai_khoan WHERE email = ?";
    $stmt = mysqli_prepare($conn, $check_quyen_sql);
    mysqli_stmt_bind_param($stmt, "s", $email);
    mysqli_stmt_execute($stmt);
    $row_check_quyen = u_stmt_fetch_assoc($stmt) ?: array('quyen'=>0,'keylimit'=>0,'uuid_limit'=>0);
    mysqli_stmt_close($stmt);

    $role = intval($row_check_quyen['quyen'] ?? 0);
    $keylimit = intval($row_check_quyen['keylimit'] ?? 0);
    $uuid_limit = intval($row_check_quyen['uuid_limit'] ?? 0);

    // Remaining key quota (keylimit - số key đã tạo)
    $result_cnt = mysqli_query($conn, "SELECT COUNT(id) AS cnt FROM package_key WHERE email = '".mysqli_real_escape_string($conn,$email)."'");
    $row_cnt = mysqli_fetch_assoc($result_cnt);
    $tongKey = intval($row_cnt['cnt'] ?? 0);
    $remainingKey = $keylimit - $tongKey;
    if ($keylimit < 0) { $remainingKey = 999999; } // -1 = unlimited (nếu bạn dùng)

    $type = $_REQUEST['type'];

    if ($type === 'resetkey') {
    // Lấy giá trị key_id từ POST và thực hiện escape để tránh SQL injection
    $id = mysqli_real_escape_string($conn, $_POST['key_id']);
    // Owner check for user
    if ($role !== 1) {
        $rs = mysqli_query($conn, "SELECT id FROM package_key WHERE id = '$id' AND email = '".mysqli_real_escape_string($conn,$email)."' LIMIT 1");
        if (!$rs || mysqli_num_rows($rs) == 0) {
            $return['error'] = 1;
            $return['msg'] = 'Key không tồn tại hoặc không thuộc về bạn.';
            die(json_encode($return));
        }
    }


    // Bắt đầu một transaction để đảm bảo tính toàn vẹn của dữ liệu
    mysqli_begin_transaction($conn);

    try {
        // Xóa bản ghi từ bảng list_uuid và devices
        mysqli_query($conn, "DELETE FROM list_uuid WHERE key_id='$id'");
        mysqli_query($conn, "DELETE FROM devices WHERE key_id='$id'");

        // Cập nhật trạng thái của key trong bảng package_key
        $update_query = "UPDATE package_key SET keystatus='1' WHERE id='$id'";
        if (mysqli_query($conn, $update_query)) {
            // Commit transaction nếu mọi thứ đều thành công
            mysqli_commit($conn);
            $return['msg'] = 'Bạn đã reset key có id ' . $id . ' thành công.';
        } else {
            // Rollback transaction nếu cập nhật không thành công
            mysqli_rollback($conn);
            $return['msg'] = 'Đã xảy ra lỗi khi cập nhật key có id ' . $id;
        }
    } catch (Exception $e) {
        // Rollback transaction nếu có lỗi xảy ra
        mysqli_rollback($conn);
        $return['msg'] = 'Đã xảy ra lỗi: ' . $e->getMessage();
    }

    // Trả về kết quả dưới dạng JSON
    die(json_encode($return));
}



    if ($type === 'delkey') {
        $id = mysqli_real_escape_string($conn, $_POST['key_id'] ?? '');
        if ($id === '') {
            $return['error'] = 1;
            $return['msg']  = 'Thiếu key_id.';
            die(json_encode($return));
        }

        // Owner check for user
        $where = "id = '$id'";
        if ($role !== 1) {
            $where .= " AND email = '".mysqli_real_escape_string($conn,$email)."'";
        }

        if (mysqli_query($conn, "DELETE FROM package_key WHERE $where")) {
            if (mysqli_affected_rows($conn) <= 0) {
                $return['error'] = 1;
                $return['msg']  = 'Key không tồn tại hoặc không thuộc về bạn.';
                die(json_encode($return));
            }
            $return['msg'] = 'Đã xoá key thành công.';
            die(json_encode($return));
        }

        $return['error'] = 1;
        $return['msg']  = 'Đã xảy ra lỗi, vui lòng thử lại.';
        die(json_encode($return));
    }


    if ($type === 'changeuuid') {
        $id = $_POST['key_id'];
        $uuid = $_POST['max_uuid'];
        
        
        
        if(!isset($uuid)){
            $return['error'] = 1;
            $return['msg']  = 'Số Lượng Người DÙng Phải Lớn Hơn 0.';
            die(json_encode($return));
        }
        $where = "id = '".mysqli_real_escape_string($conn,$id)."'";
        if ($role !== 1) { $where .= " AND email = '".mysqli_real_escape_string($conn,$email)."'"; }

        if (mysqli_query($conn, "UPDATE package_key SET max_uuid = '".mysqli_real_escape_string($conn,$uuid)."' WHERE " . $where)) {
            $return['msg'] = 'Bạn đã cập nhật số lượng người dùng chung key có id ' . $id . ' đến ' . $uuid . '.';
            die(json_encode($return));
        }
    }
    
    if ($type == 'deleteAllKeys') {
        // User xoá toàn bộ key của mình (Admin cũng chỉ tác động theo email session ở đây)
        $where = "email = '".mysqli_real_escape_string($conn,$email)."'";
        if (mysqli_query($conn, "DELETE FROM package_key WHERE $where")) {
            $return['msg'] = 'Bạn đã xoá toàn bộ key thành công.';
            die(json_encode($return));
        }
        $return['error'] = 1;
        $return['msg']  = 'Không thể xoá toàn bộ key.';
        die(json_encode($return));
    }

if ($type == 'deleteSelectedKeys') {
        $keyIds = $_POST['keyIds']; 
        $keyIdsArray = explode(',', $keyIds); 

        // Bắt đầu transaction
        mysqli_begin_transaction($conn);

        try {
            // Xóa key
            $deleteQuery = "DELETE FROM package_key WHERE id IN (" . implode(',', $keyIdsArray) . ")";
            if (mysqli_query($conn, $deleteQuery)) {
                // Đếm số lượng key đã xóa
                $deletedCount = mysqli_affected_rows($conn);

                // Lấy key limit hiện tại
                $result = mysqli_query($conn, "SELECT keylimit FROM tai_khoan WHERE email = '$email'");
                $row = mysqli_fetch_assoc($result);
                $currentKeyLimit = $row['keylimit'];

                // Tính toán key limit mới
                $newKeyLimit = $currentKeyLimit - $deletedCount; // cộng thêm số key đã xóa

                // Cập nhật key limit
                $updateQuery = "UPDATE tai_khoan SET keylimit = '$newKeyLimit' WHERE email = '$email'";
                if (mysqli_query($conn, $updateQuery)) {
                    // Commit transaction
                    mysqli_commit($conn);

                    $return['msg'] = 'Đã xóa thành công ' . $deletedCount . ' key.';
                } else {
                    throw new Exception('Lỗi không thể cập nhật key limit.');
                }
            } else {
                throw new Exception('Lỗi không thể xóa key.');
            }
        } catch (Exception $e) {
            // Rollback transaction khi có lỗi
            mysqli_rollback($conn);

            $return['msg'] = 'Có lỗi xảy ra: ' . $e->getMessage();
            $return['error'] = 1; // Thiết lập mã lỗi
        }

        die(json_encode($return));
    }

    if ($type == 'genkey') {
    $dateCount = isset($_POST['datekey']) ? $_POST['datekey'] : 0;
    $package = isset($_POST['package']) ? $_POST['package'] : '';
    $soluong = $_POST['quantity'];
    // $max_uuid = $_POST['uuid'];

    $keyArray = array();

    if ($soluong > 0) {
        for ($i = 0; $i < $soluong; $i++) {
            if ($dateCount == 1) {
                $key = days_keygen($_SESSION['level']);
            } else if ($dateCount == 7) {
                $key = week_keygen($_SESSION['level']);
            } else if ($dateCount == 30) {
                $key = month_keygen($_SESSION['level']);
            } else if ($dateCount == 365) {
                $key = year_keygen($_SESSION['level']);
            }

            if (!empty($key)) {
                array_push($keyArray, $key);

                // Chèn key vào cơ sở dữ liệu
                $query = mysqli_query($conn, "INSERT INTO package_key (package_id, devicekey, datecount, date, keytype, keystatus, email) VALUES ('$package', '$key', '$dateCount', '3000-12-30 00:00:00', '4', '0', '$email')");

                // Kiểm tra kết quả chèn
                if (!$query) {
                    $return['msg'] = 'Đã xảy ra lỗi, vui lòng thao tác lại.';
                    $return['data'] = array();
                    $return['debug'] = array(
                        'error' => mysqli_error($conn),
                        'query' => $query
                    );
                    echo json_encode($return);
                    return;
                }
            }
        }
    } else {
        $return['msg'] = 'Số lượng key không hợp lệ.';
        $return['data'] = array();
        $return['debug'] = array(
            'dateCount' => $dateCount,
            'package' => $package,
            'soluong' => $soluong,
            'level' => $_SESSION['level']
        );
        echo json_encode($return);
        return;
    }

    $return['msg'] = 'Đã tạo thành công ' . $soluong . ' key !';
    $return['data'] = $keyArray;
    $return['debug'] = array(
        'dateCount' => $dateCount,
        'package' => $package,
        'soluong' => $soluong,
        'level' => $_SESSION['level']
    );
    echo json_encode($return);
    return;
}

    if ($type === 'guestgenkey') {
        $datecount = $_POST['datekey'];
        $id = $_POST['post_id'];
        $post_buyer = $_POST['post_buy'];
        $result_sell = mysqli_query($conn, "SELECT postuser,quyen, email, debid,keylimit FROM product
        inner join tai_khoan on tai_khoan.username = product.postuser
         WHERE product.id = '$id'");
        $row_sell = mysqli_fetch_array($result_sell);
        $email_seller = $row_sell['email'];
        $debid_seller = $row_sell['debid'];
        $result_buyer = mysqli_query($conn, "SELECT * FROM tai_khoan where id = '$post_buyer'");
        $row_buyer = mysqli_fetch_array($result_buyer);
        $username_buyer = $row_buyer['username'];
        if ($row_buyer['countkey'] >= $row_buyer['countkeylimit']) {
            $return['error'] = 1;
            $return['msg']  = 'Bạn đã đạt giới hạn nhận key trong ngày. Hãy quay lại vào ngày hôm sau nhé !';
            die(json_encode($return));
        }
        $nv = "SELECT count(id) as soluong FROM package_key where email = '$email_seller'";
        $resultNV = mysqli_query($conn, $nv);
        $rowNV = mysqli_fetch_array($resultNV);
        $tongKey = $rowNV['soluong'];
        if ($row_sell['keylimit'] - $tongKey <= 0) {
            $return['error'] = 1;
            $return['msg']  = 'Chủ sở hữu gói đã hết key free, liên hệ trực tiếp để biết thêm thông tin !';
            die(json_encode($return));
        }
        if ($row_sell['quyen'] == 2) {
            $key = $row_sell["username"] . '-week-' . substr(str_shuffle("0123456789abcdefghijklmnopqrstuvwxyz"), 0, 16);
        } else {
            $key = $row_sell["username"] . '-week-' . substr(str_shuffle("0123456789abcdefghijklmnopqrstuvwxyz"), 0, 16);
        }
        if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
            $IP = $_SERVER['HTTP_CLIENT_IP'];
        } else if (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
            $IP = $_SERVER['HTTP_X_FORWARDED_FOR'];
        } else {
            $IP = $_SERVER['REMOTE_ADDR'];
        }

        $query = mysqli_query($conn, "INSERT into package_key(devicekey,datecount,keytype,keystatus,email) values('$key','$datecount','4','0','$email_seller')");

        if ($query) {
            mysqli_query($conn, "INSERT into historykey(usernameget,gettype,debid,devicekey,getip) values('$username_buyer','0','$debid_seller','$key', '$IP')");
            mysqli_query($conn, "UPDATE tai_khoan set countkey = countkey + 1 where id = '$post_buyer'");
            $return['msg'] = 'Đã get thành công 1 key thường. Bạn có thể vào trang cá nhân để xem chi tiết. Key của bạn là: ' . $key . ' ';
            die(json_encode($return));
        } else {
            $return['error'] = 1;
            $return['msg']  = 'Đã xảy ra lỗi, vui lòng thao tác lại.';
            die(json_encode($return));
        }
    }

    if ($type === 'createkey') {
        $date = $_POST['date'];
        $soluong = $_POST['quantity'];
        $package = $_POST['package'];
        $keytype = $_POST['keytype'];
        $max_uuid = $_POST['max_uuid'];

        // === User quota + ownership ===
        $soluong = intval($soluong);
        if ($soluong <= 0) { $return['error']=1; $return['msg']='Số lượng key không hợp lệ.'; die(json_encode($return)); }

        if ($role !== 1) {
            if ($remainingKey <= 0) { $return['error']=1; $return['msg']='Bạn đã hết lượt tạo key. Vui lòng nâng cấp/gia hạn.'; die(json_encode($return)); }
            if ($soluong > $remainingKey) { $return['error']=1; $return['msg']='Bạn chỉ còn ' . $remainingKey . ' lượt tạo key.'; die(json_encode($return)); }

            $pkg_id = mysqli_real_escape_string($conn, $package);
            $rsPkg = mysqli_query($conn, "SELECT id FROM package WHERE id = '$pkg_id' AND email = '".mysqli_real_escape_string($conn,$email)."' LIMIT 1");
            if (!$rsPkg || mysqli_num_rows($rsPkg) == 0) { $return['error']=1; $return['msg']='Package không hợp lệ hoặc không thuộc về bạn.'; die(json_encode($return)); }
        }

        // uuid_limit check
        $max_uuid = intval($max_uuid);
        if ($uuid_limit > 0 && $max_uuid > $uuid_limit) {
            $return['error'] = 1;
            $return['msg']  = 'Bạn chỉ được tạo tối đa ' . $uuid_limit . ' người dùng!';
            die(json_encode($return));
        }
        $keyArray = array();
        for ($i = 0; $i < $soluong; $i++) {
            $key = basic_keygen($_SESSION['level']);
            array_push($keyArray, $key);
            $query = mysqli_query($conn, "INSERT into package_key(package_id,max_uuid ,devicekey,date,keytype,keystatus,email) values('$package','$max_uuid', '$key','$date','$keytype','1','$email')");
        }
        if ($query) {
            $return['msg'] = 'Đã tạo thành công ' . $soluong . ' key !';
            $return['data'] = $keyArray;
            die(json_encode($return));
        } else {
            $return['error'] = 1;
            $return['msg']  = 'Đã xảy ra lỗi, vui lòng thao tác lại.';
            die(json_encode($return));
        }
    }

    if ($type === 'createkey2') {
        $dateCount = $_POST['date']; // number 
        // add $dateCount to current date
        


        $soluong = $_POST['quantity'];
        $keytype = $_POST['keytype'];
        $package = $_POST['package'];
        $max_uuid = $_POST['max_uuid'];

        // === User quota + ownership (key động) ===
        $soluong = intval($soluong);
        if ($soluong <= 0) { $return['error']=1; $return['msg']='Số lượng key không hợp lệ.'; die(json_encode($return)); }

        if ($role !== 1) {
            if ($remainingKey <= 0) { $return['error']=1; $return['msg']='Bạn đã hết lượt tạo key. Vui lòng nâng cấp/gia hạn.'; die(json_encode($return)); }
            if ($soluong > $remainingKey) { $return['error']=1; $return['msg']='Bạn chỉ còn ' . $remainingKey . ' lượt tạo key.'; die(json_encode($return)); }

            $pkg_id = mysqli_real_escape_string($conn, $package);
            $rsPkg = mysqli_query($conn, "SELECT id FROM package WHERE id = '$pkg_id' AND email = '".mysqli_real_escape_string($conn,$email)."' LIMIT 1");
            if (!$rsPkg || mysqli_num_rows($rsPkg) == 0) { $return['error']=1; $return['msg']='Package không hợp lệ hoặc không thuộc về bạn.'; die(json_encode($return)); }
        }

        // uuid_limit check
        $max_uuid = intval($max_uuid);
        if ($uuid_limit > 0 && $max_uuid > $uuid_limit) {
            $return['error'] = 1;
            $return['msg']  = 'Bạn chỉ được tạo tối đa ' . $uuid_limit . ' người dùng!';
            die(json_encode($return));
        }

        $keyArray = array();
        for ($i = 0; $i < $soluong; $i++) {
            $key = basic_keygen($_SESSION['level']);
            array_push($keyArray, $key);
            $query = mysqli_query($conn, "INSERT into package_key(package_id,max_uuid ,devicekey,datecount,keytype,keystatus,email,date) values('$package','$max_uuid', '$key','$dateCount','$keytype','0','$email','3000-12-30 00:00:00')");
        }
        if ($query) {
            $return['msg'] = 'Đã tạo thành công ' . $soluong . ' key động. Thời hạn sẽ hiển thị khi user kích hoạt !';
            $return['data'] = $keyArray;
            die(json_encode($return));
        } else {
            $return['error'] = 1;
            $return['msg']  = 'Đã xảy ra lỗi, vui lòng thao tác lại.';
            die(json_encode($return));
        }
    }

    // remove key expired
    // remove key expired
    if ($type === 'removeKeyExpried') {
        // Xoá key hết hạn: user chỉ xoá của mình; admin có thể truyền email để xoá theo email đó
        $where = "email = '".mysqli_real_escape_string($conn,$email)."' AND `date` IS NOT NULL AND `date` < NOW()";
        if ($role === 1 && isset($_POST['email']) && $_POST['email'] !== '') {
            $em = mysqli_real_escape_string($conn, $_POST['email']);
            $where = "email = '$em' AND `date` IS NOT NULL AND `date` < NOW()";
        }

        if (mysqli_query($conn, "DELETE FROM package_key WHERE $where")) {
            $return['msg'] = 'Đã xoá key hết hạn thành công.';
            die(json_encode($return));
        }

        $return['error'] = 1;
        $return['msg']  = 'Không thể xoá key hết hạn.';
        die(json_encode($return));
    }
}
