<?php include 'layouts/session_user.php'; ?>
<?php include 'layouts/head-main.php';

$email = $_SESSION['email'];

// Lấy dữ liệu package keys
$showData = "SELECT pk.id, pk.max_uuid, pk.date, pk.keytype, pk.devicekey, pk.keystatus, pk.datecount, (pk.date < NOW()) as expired, p.debname  
             FROM package_key pk
             JOIN package p ON pk.package_id = p.id
             WHERE pk.email = '$email'
             ORDER BY pk.id ASC";
$result = mysqli_query($conn, $showData);
$arrShow = array();
while ($row = mysqli_fetch_array($result)) {
    $arrShow[] = $row;
}

// Lấy tổng số key
$nv = "SELECT count(id) as soluong FROM package_key where email = '$email'";
$resultNV = mysqli_query($conn, $nv);
$rowNV = mysqli_fetch_array($resultNV);
$tongKey = $rowNV['soluong'];

// Lấy danh sách thiết bị và nhóm theo key_id
$sqlDevices = "SELECT udid, key_id FROM devices";
$resultDevices = mysqli_query($conn, $sqlDevices);

$devicesPerKey = [];
while ($row = mysqli_fetch_assoc($resultDevices)) {
  $keyId = $row['key_id'];
  $devicesPerKey[$keyId][] = $row['udid'];
}

?>

<head>

    <title>List Key | Unitoreios API Unitoreios</title>
    <?php include 'layouts/head.php'; ?>

    <!-- DataTables -->
    <link href="assets/libs/datatables.net-bs4/css/dataTables.bootstrap4.min.css" rel="stylesheet" type="text/css" />

    <!-- Responsive datatable examples -->
    <link href="assets/libs/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css" rel="stylesheet"
        type="text/css" />

    <?php include 'layouts/head-style.php'; ?>
     <style>
        /* CSS cho animation khi chạm */
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }
        
        /* Ẩn cột checkbox mặc định */
        .delete-checkbox-column {
            display: none;
        }
        
        /* Hiển thị cột checkbox khi ở chế độ chọn để xóa */
        .delete-mode .delete-checkbox-column {
            display: table-cell;
        }
    </style>

</head>

<?php include 'layouts/body.php'; ?>

<!-- Begin page -->
<div id="layout-wrapper">

    <?php include 'layouts/menu.php'; ?>

    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="main-content">
        <div class="modal fade" id="exampleModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1"
            role="dialog" aria-labelledby="staticBackdropLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <form method="POST">
                        <div class="modal-header">
                            <span style="font-size: 18px;">Tạo Key Tĩnh</span>
                        </div>
                        <div class="modal-body">
                            <div class="form-group">
                                <label for="recipient-name" class="control-label">Số lượng Key:</label>
                                <input type="number" min="1" max="<?php echo $row_acc['keylimit'] - $tongKey ?>"
                                    class="form-control" id="soluong">
                            </div>
                            <div class="form-group">
                                <label class="control-label">Số lượng Người Dùng:</label>
                                <input id="uuid" type="number" min="1" max="<?php echo $row_acc['uuid_limit'] ?>"
                                    class="form-control">
                            </div>
                            <div class="form-group">
                                <label>Loại key: </label>
                                <select class="form-control" id="keytype">
                                    
                                    <option value="4" selected>Normal</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label>Chọn Package: </label>

                                <select class="form-control" id="package">
                                    <?php
                                $dev = mysqli_query($conn, "SELECT id, debname FROM package where email = '$email' ORDER BY id ASC");
                                $arrDev = array();
                                while ($row = mysqli_fetch_array($dev)) {
                                    $arrDev[] = $row;
                                }
                                foreach ($arrDev as $data) {
                                    ?>
                                    <option value="<?= $data['id'] ?>"><?= $data['debname'] ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                            <div class="form-group">
                                <label>Thời hạn: </label>
                                <input type="datetime-local" class="form-control" placeholder="Thời gian sử dụng" id="date">
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-light" data-bs-dismiss="modal">Hủy bỏ</button>
                            <button type="button" class="btn btn-primary"
                                onclick="createkey(<?php echo $tongKey ?>)">Tạo Key</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class="modal fade" id="modalkey" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1"
            role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <form method="POST">
                        <div class="modal-header">
                            <span style="font-size: 18px;">Tạo Key động</span>
                        </div>
                        <div class="modal-body">
                            <div class="form-group">
                                <label for="recipient-name" class="control-label">Số lượng:</label>
                                <input type="number" min="1" max="<?php echo $row_acc['keylimit'] - $tongKey ?>"
                                    class="form-control" id="soluong2">
                            </div>
                            <div class="form-group">
                                <label class="control-label">Số lượng Người Dùng:</label>
                                <input id="uuid2" type="number" min="1"
                                    class="form-control">
                            </div>
                            <div class="form-group">
                                <label>Key type: </label>
                                <select class="form-control" id="keytype2">
                                    <option value="4" selected>Normal</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label>Package: </label>

                                <select class="form-control" id="package2">
                                    <?php
                                $dev = mysqli_query($conn, "SELECT id, debname FROM package where email = '$email' ORDER BY id ASC");
                                $arrDev = array();
                                while ($row = mysqli_fetch_array($dev)) {
                                    $arrDev[] = $row;
                                }
                                foreach ($arrDev as $data) {
                                    ?>
                                    <option value="<?= $data['id'] ?>"><?= $data['debname'] ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                            <div class="form-group">
                                <label>Số Ngày: </label>
                                <input type="number" min="1" class="form-control" id="datecount">
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-light" data-bs-dismiss="modal">Hủy bỏ</button>
                            <button type="button" class="btn btn-primary"
                                onclick="createkey2(<?php echo $tongKey ?>)">Tạo Key</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class="page-content">
            <div class="container-fluid">

                <!-- start page title -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                            <h4 class="mb-sm-0 font-size-18">Device List</h4>

                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a href="javascript: void(0);">Menu</a></li>
                                    <li class="breadcrumb-item active">Danh Sách Thiết Bị</li>
                                </ol>
                            </div>

                        </div>
                    </div>
                </div>
                <!-- end page title -->

                <div class="row">
                    <div class="col-lg-12">
                        <div class="card">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-sm">
                                        <div class="mb-4">
                                            <button type="button" data-bs-toggle='modal' data-bs-target='#exampleModal'
                                                class="btn btn-light waves-effect waves-light"><i
                                                    class="bx bx-plus me-1"></i> Tạo key tĩnh</button>
                                            <div class="btn-group">
                                                <button type="button" data-bs-toggle='modal' data-bs-target='#modalkey'
                                                    class="btn btn-primary"><i class="bx bx-plus me-1"></i> Tạo Key
                                                    động</button>
                                                <button type="button"
                                                    class="btn btn-primary dropdown-toggle dropdown-toggle-split"
                                                    data-bs-toggle="dropdown" aria-expanded="false">
                                                    <i class="mdi mdi-chevron-down"></i>
                                                </button>
                                                <div class="dropdown-menu">
                                                    <a class="dropdown-item" onclick="genkeyday(<?php echo $tongKey ?>)"
                                                        href="#">Key Ngày</a>
                                                    <a class="dropdown-item"
                                                        onclick="genkeyweek(<?php echo $tongKey ?>)" href="#">Key
                                                        Tuần</a>
                                                    <a class="dropdown-item"
                                                        onclick="genkeymonth(<?php echo $tongKey ?>)" href="#">Key
                                                        Tháng</a>
                                                    <a class="dropdown-item"
                                                        onclick="genkeyyear(<?php echo $tongKey ?>)" href="#">Key
                                                        Năm</a>
                                                    <div class="dropdown-divider"></div>
                                                    <button class="dropdown-item" data-bs-toggle='modal'
                                                        data-bs-target='#modalkey'>Tuỳ Chọn</button>
                                                </div>
                                            </div><!-- /btn-group -->
                                            <button type="button" onclick="help()"
                                                class="btn btn-light waves-effect waves-light"><i
                                                    class="bx bx-help-circle me-1"></i> Hướng Dẫn</button>
                                                    <button type="button" onclick="deleteAllKeys()" class="btn btn-danger waves-effect waves-light">
                                                        <i class="bx bx-trash me-1"></i> Xóa Toàn Bộ Key
                                                    </button>
                                                    <button type="button" id="select-delete-button" onclick="toggleDeleteMode()" class="btn btn-warning waves-effect waves-light delete-button">
                                                <i class="bx bx-check-circle me-1"></i> Chọn key để xóa
                                            </button>
                                             
                                            
                                            <!-- Nút xác nhận xóa -->
                                            <button type="button" onclick="confirmDeleteKeys()" class="btn btn-danger" id="confirm-delete-button" style="display: none;" disabled> 
                                                <i class="bx bx-trash me-1"></i> Xác nhận xóa
                                            </button>
                                                    
                                            <button type="button" onclick="removeKeyExpried()"
                                                class="btn btn-danger waves-effect waves-light">
                                                <i class="bx bx-trash me-1"></i> Xóa Key Hết Hạn
                                            </button>
                                            
                                        </div>
                                        <p><i class="bx bx-key"></i> Lượng Key Còn Lại:
                                            <?= $row_acc['keylimit'] - $tongKey ?>
                                        </p>
                                    </div>

                                </div>
                                <!-- end row -->

                                <div class="table-responsive">
                                    <table class="table align-middle datatable dt-responsive table-check nowrap"
                                        style="border-collapse: collapse; border-spacing: 0 8px; width: 100%;">
                                        <thead>
                                            <tr class="bg-transparent">
                                                <th style="width: 9px" class="text-center">STT</th>
                                                <th style="width: 9px" class="text-center delete-checkbox-column">Chọn</th> 
                                                <th style="width: 9px" class="text-center">ID</th>
                                                <th class="text-center">Tên Package</th>
                                                <th data-priority="1" class="text-center">Key</th>
                                                
                                                <th data-priority="1" class="text-center">Ngày Hết Hạn</th>
                                                <th data-priority="1" class="text-center">UDID</th>
                                                <th data-priority="1" class="text-center">Trạng Thái</th>
                                                <th class="text-center" style="width: 9px">Sửa</th>
                                                <th class="text-center" style="width: 9px">Reset</th>
                                                <th class="text-center" style="width: 9px">Số lượng UUID</th>
                                                <th class="text-center" style="width: 9px">Xóa</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                              $count = 1;
                                              foreach ($arrShow as $arrS) {
                                                // Lấy số lượng thiết bị dùng chung key_id
                                                $keyId = $arrS['id'];
                                                $sharedDevicesCount = isset($devicesPerKey[$keyId]) ? count(array_unique($devicesPerKey[$keyId])) : 0;
                                              ?>
                                                <tr>
                                                  <td><?php echo $count; ?></td>
                                                  <td class="text-center delete-checkbox-column">
                                                        <input type="checkbox" class="key-checkbox" value="<?php echo $arrS['id']; ?>">
                                                    </td>
                                                  <td><?php echo $arrS['id']; ?></td>
                                                  <td><?php echo $arrS['debname']; ?></td>
                                                  <td id="debhash" onclick="copyText('<?=$arrS['devicekey']?>')">
                                                    <?php echo $arrS['devicekey']; ?>
                                                  </td>
                                                  <td class="text-center">
                                                    <?php echo date("d/m/Y H:i:s", strtotime($arrS['date'])); ?>
                                                  </td>
                                                  <td class="text-center">
                                                    <?php 
                                                      // Hiển thị số lượng thiết bị đang dùng chung / giới hạn
                                                      echo $sharedDevicesCount . '/' . $arrS['max_uuid']; 
                                                    ?>
                                                  </td>

                                                <td>
                                                    <?php
                                                        $today = date("Y-m-d H:i:s");
                                                        if ($arrS['keytype'] != 1 && $arrS['keystatus'] == 1 && strtotime($today) < strtotime($arrS['date'])) {
                                                            echo '<span class="badge rounded-pill bg-success"> Hoạt động </span>';
                                                        } else if ($arrS['keytype'] != 1 && $arrS['keystatus'] == 1 && strtotime($today) > strtotime($arrS['date'])) {
                                                            echo '<span class="badge rounded-pill bg-danger"> Hết hạn </span>';
                                                            // } else if (strtotime($today) >= strtotime($arrS['date']) && $arrS['datecount'] == 0) {
                                                            //     echo '<span class="badge rounded-pill bg-danger"> Expires </span>';
                                                        } else {
                                                            echo '<span class="badge rounded-pill bg-warning"> Đang chờ </span>';
                                                        }
                                                        ?>
                                                </td>
                                                <td class="text-center">
                                                    <a href="danh-sach-thiet-bi?key=<?=$arrS['id']?>"><span class='btn btn-soft-light btn-sm w-xs waves-effect btn-label waves-light'><i class='bx bx-reset label-icon'></i> Edit
                                                    </span></a>
                                                </td>
                                                <td class="text-center">
                                                    <button data-id="<?php echo $arrS['id']; ?>" data-keystatus="<?php echo $arrS['keystatus']; ?>" onclick="rskey(this)" class="btn btn-soft-light btn-sm w-xs waves-effect btn-label waves-light">
                                                        <i class="bx bx-reset label-icon"></i> Reset
                                                    </button>
                                                </td>


                                                <td>
                                                    <?php
                                                        echo "<button onclick='setuuid(" . $arrS['id'] . "," . $arrS['max_uuid'] . ")' class='btn btn-soft-light btn-sm w-xs waves-effect btn-label waves-light'><i class='bx bx-calendar-plus label-icon'></i> Update</button>";
                                                        ?>
                                                </td>
                                                <td>
                                                    <?php
                                                        echo "<button onclick='del(" . $arrS['id'] . ")' class='btn btn-soft-light btn-sm w-xs waves-effect btn-label waves-light'><i class='bx bx-trash label-icon'></i> Delete</button>";
                                                        ?>
                                                </td>
                                            </tr>
                                            <?php
                                                $count++;
                                            }
                                            ?>
                                        </tbody>
                                    </table>
                                </div>
                                <!-- end table responsive -->
                            </div>
                            <!-- end card body -->
                            
                        </div>
                        <!-- end card -->
                    </div>
                    <!-- end col -->
                </div>
                <!-- end row -->
            </div> <!-- container-fluid -->
        </div>
        <!-- End Page-content -->

        <?php include 'layouts/footer.php'; ?>
    </div>
    <!-- end main content-->

</div>
<!-- END layout-wrapper -->

<!-- Right Sidebar -->
<?php include 'layouts/right-sidebar.php'; ?>
<!-- /Right-bar -->

<!-- JAVASCRIPT -->

<?php include 'layouts/vendor-scripts.php'; ?>

<!-- flatpickr js -->
<script src="assets/libs/flatpickr/flatpickr.min.js"></script>

<!-- Required datatable js -->
<script src="assets/libs/datatables.net/js/jquery.dataTables.min.js"></script>
<script src="assets/libs/datatables.net-bs4/js/dataTables.bootstrap4.min.js"></script>

<!-- Responsive examples -->
<script src="assets/libs/datatables.net-responsive/js/dataTables.responsive.min.js"></script>
<script src="assets/libs/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js"></script>

<!-- init js -->
<script src="assets/js/pages/list-key.init.js"></script>

<script src="assets/js/app.js"></script>
</body>
<script>
var baseurl = window.location.protocol + "//" + window.location.host;
const keylimit = <?php echo $row_acc['keylimit'] ?>;

function help() {
    Swal.fire({
        title: 'Hướng dẫn sử dụng',
        text: 'Key tĩnh là thời hạn sẽ tính ngay khi bạn tạo ra key, key động thời hạn sẽ bắt đầu tính khi người dùng sử dụng để kích hoạt. Nếu có nhu cầu nhiều key hơn, vui lòng liên hệ admin để nâng cấp. \nZalo: Cập Nhật Thông Tin Sau',
        icon: 'info',
        heightAuto: 'true',
        width: '500px'
    });
}

function showudid(id) {
    Swal.fire({
        title: 'Xác nhận',
        icon: 'warning',
        text: `Bạn chắc chắn muốn lấy udid thiết bị có id ${id} ?`,
        showCancelButton: true,
        confirmButtonText: "Xác nhận",
    }).then(function(result) {
        if (result.value) {
            $.ajax({
                url: 'module/ajax-device.php',
                type: 'POST',
                dataType: 'JSON',
                data: {
                    type: 'getudid',
                    device_id: id
                },
                beforeSend: function() {
                    Swal.fire({
                        title: 'Thông báo',
                        text: 'Please wait...',
                        icon: 'info',
                        showConfirmButton: false,
                        allowOutsideClick: false,
                        timerProgressBar: true,
                        didOpen: () => {
                            Swal.showLoading()
                        }
                    })
                },
                success: (data) => {
                    if (data.error) {
                        Swal.fire("Thông báo", data.msg, "error");
                    } else {
                        Swal.fire({
                            title: "Kết quả trả về",
                            text: `${data.msg}`,
                            icon: "success",
                            showCancelButton: true,
                            confirmButtonText: "Copy",
                            cancelButtonText: "Close"
                        }).then(function(result) {
                            if (result.value) {
                                copyToClipboard(data.msg);
                            }
                        });
                    }
                }
            });
        }
    });
}

function copyText(textToCopy) {
      Swal.fire({
                            title: "Kết quả trả về",
                            text: `${textToCopy}`,
                            icon: "success",
                            showCancelButton: true,
                            confirmButtonText: "Copy",
                            cancelButtonText: "Close"
                        }).then(function(result) {
                            if (result.value) {
                                copyToClipboard(textToCopy);
                            }
                        });
    }
    
function del(id) {
    Swal.fire({
        title: 'Xác nhận',
        icon: 'warning',
        text: `Bạn chắc chắn muốn xoá key có id ${id} ?`,
        showCancelButton: true,
        confirmButtonText: "Xác nhận",
    }).then(function(result) {
        if (result.value) {
            $.ajax({
                url: 'module/ajax-key.php',
                type: 'POST',
                dataType: 'JSON',
                data: {
                    type: 'delkey',
                    key_id: id
                },
                beforeSend: function() {
                    Swal.fire({
                        title: 'Thông báo',
                        text: 'Please wait...',
                        icon: 'info',
                        showConfirmButton: false,
                        allowOutsideClick: false,
                        timerProgressBar: true,
                        didOpen: () => {
                            Swal.showLoading()
                        }
                    })
                },
                success: (data) => {
                    if (data.error) {
                        Swal.fire("Thông báo", data.msg, "error");
                    } else {
                        Swal.fire("Thông báo", data.msg, "success");
                        setTimeout(function() {
                            location.reload();
                        }, 1500);
                    }
                }
            });
        }
    });
}

function deleteAllKeys() {
    Swal.fire({
        title: 'Xác nhận',
        icon: 'warning',
        text: `Bạn chắc chắn muốn xoá toàn bộ key?`,
        showCancelButton: true,
        confirmButtonText: "Xác nhận",
    }).then(function(result) {
        if (result.value) {
            $.ajax({
                url: 'module/ajax-key.php',
                type: 'POST',
                dataType: 'JSON',
                data: {
                    type: 'deleteAllKeys', // Thêm type mới
                },
                beforeSend: function() {
                    Swal.fire({
                        title: 'Thông báo',
                        text: 'Vui lòng chờ...',
                        icon: 'info',
                        showConfirmButton: false,
                        allowOutsideClick: false,
                        timerProgressBar: true,
                        didOpen: () => {
                            Swal.showLoading()
                        }
                    })
                },
                success: (data) => {
                    if (data.error) {
                        Swal.fire("Thông báo", data.msg, "error");
                    } else {
                        Swal.fire("Thông báo", data.msg, "success");
                        setTimeout(function() {
                            location.reload();
                        }, 1500);
                    }
                }
            });
        }
    });
}

function createkey(soluong) {
    var quantity = $('#soluong').val();
    var keytype = $('#keytype').val();
    var dateexp = $('#date').val();
    var package = $('#package').val();
    var uuid = $('#uuid').val();
    if(uuid > <?=$row_acc['uuid_limit']?>){
        Swal.fire("Thông báo", `Số lượng người dùng chung key tối đa là <?=$row_acc['uuid_limit']?>!`, "error");
        return;
    }
    if (soluong < keylimit) {
        if (quantity > keylimit - soluong) {
            Swal.fire("Thông báo", `Số lượng key bạn vừa nhập đã chạm tới giới hạn !`, "error");
            return;
        }
        if (!package) {
            Swal.fire("Thông báo", `Vui lòng chọn package !`, "error");
            return;
        }
        if (!uuid) {
            Swal.fire("Thông báo", `Vui nhập số lượng người dùng chung key !`, "error");
            return;
        }
        if (!dateexp) {
            Swal.fire("Thông báo", `Vui lòng chọn thời hạn !`, "error");
            return;
        }
        var today2 = new Date();
        const yyyy = today2.getFullYear();
        let mm = today2.getMonth() + 1; // Months start at 0!
        let dd = today2.getDate();
        let H = today2.getHours();
        let i = today2.getMinutes();
        let s = today2.getSeconds();

        if (dd < 10) dd = '0' + dd;
        if (mm < 10) mm = '0' + mm;
        if (H < 10) H = '0' + H;
        if (i < 10) i = '0' + i;
        if (s < 10) s = '0' + s;

        today2 = yyyy + '-' + mm + '-' + dd + '-' + H + '-' + i + '-' + s;

        if (new Date(dateexp) <= new Date(today2)) {
          Swal.fire("Thông báo", `Thời hạn phải lớn hơn 1 ngày !`, "error");
          return;
        }
                $.ajax({
            url: 'module/ajax-key.php',
            type: 'POST',
            dataType: 'JSON',
            data: {
                type: 'createkey',
                quantity: quantity,
                max_uuid:uuid,
                keytype: keytype,
                package: package,
                date: dateexp
            },
            beforeSend: function() {
                Swal.fire({
                    title: 'Thông báo',
                    text: 'Please wait...',
                    icon: 'info',
                    showConfirmButton: false,
                    allowOutsideClick: false,
                    timerProgressBar: true,
                    didOpen: () => {
                        Swal.showLoading()
                    }
                })
            },
            success: (data) => {
                console.log(data);
                let html = `
                        <div class="form-group">
                            <label for="key">Key</label>
                            <textarea class="form-control" id="key" rows="3">${data.data.map(
                        (item) => item
                    ).join("\n") || ""}</textarea>
                            </textarea>
                        </div>
                    `
                if (data.error) {
                    Swal.fire("Thông báo", data.msg, "error");
                } else {
                    // disable button create key
                    $('#exampleModal').modal('hide');
                    $('#createkey').attr('disabled', true);
                    $('#createkey').html('Đã tạo key');
                    // show key
                    Swal.fire({
                        title: "Kết quả trả về",
                        html: html,
                        icon: "success",
                        showCancelButton: true,
                        confirmButtonText: "Copy",
                        cancelButtonText: "Close"
                    }).then(function(result) {
                        if (result.value) {
                            copyToClipboard(data.data.join("\n"));
                            // copy success reload page
                            setTimeout(function() {
                                location.reload();
                            }, 1500);
                        }
                    });
                }
            }
        })
    } else {
        $('#exampleModal').modal('hide');
        Swal.fire("Thông báo", `Số lượng key hiện tại của bạn đã đến giới hạn !`, "error");
        return;
    }
}

function copyToClipboard(data) {
    // send data to clipboard
    navigator.clipboard.writeText(data).then(function() {
        Swal.fire("Thông báo", "Đã copy vào clipboard", "success");
    }, function() {
        Swal.fire("Thông báo", "Không thể copy vào clipboard", "error");
    });
}

function createkey2(soluong) {
    var quantity = $('#soluong2').val();
    var keytype = $('#keytype2').val();
    var dateexp = $('#datecount').val();
    var uuid = $('#uuid2').val();
    var package = $('#package2').val();
    if(uuid > <?=$row_acc['uuid_limit']?>){
        Swal.fire("Thông báo", `Số lượng người dùng chung key tối đa là <?=$row_acc['uuid_limit']?>!`, "error");
        return;
    }
    if (soluong < keylimit) {
        if (quantity > keylimit - soluong) {
            Swal.fire("Thông báo", `Số lượng key bạn vừa nhập đã chạm tới giới hạn !`, "error");
            return;
        }
        if (!package) {
            Swal.fire("Thông báo", `Vui lòng chọn package !`, "error");
            return;
        }
        if (!uuid) {
            Swal.fire("Thông báo", `Vui nhập số lượng người dùng chung key !`, "error");
            return;
        }
        if (!dateexp) {
            Swal.fire("Thông báo", `Vui lòng chọn thời hạn !`, "error");
            return;
        }
        $.ajax({
            url: 'module/ajax-key.php',
            type: 'POST',
            dataType: 'JSON',
            data: {
                type: 'createkey2',
                quantity: quantity,
                max_uuid: uuid,
                keytype: keytype,
                package: package,
                date: dateexp
            },
            beforeSend: function() {
                Swal.fire({
                    title: 'Thông báo',
                    text: 'Please wait...',
                    icon: 'info',
                    showConfirmButton: false,
                    allowOutsideClick: false,
                    timerProgressBar: true,
                    didOpen: () => {
                        Swal.showLoading()
                    }
                })
            },
            success: (data) => {
                if (data.error) {
                    Swal.fire("Thông báo", data.msg, "error");
                } else {
                    // disable button create key
                    $('#modalkey').modal('hide');
                    $('#createkey2').attr('disabled', true);
                    $('#createkey2').html('Đã tạo key');
                    // show key
                    let html = `
                        <div class="form-group">
                            <label for="key">Key</label>
                            <textarea class="form-control" id="key" rows="3">${data.data.map(
                            (item) => item
                        ).join("\n") || ""}</textarea>
                            </textarea>
                        </div>
                    `
                    Swal.fire({
                        title: "Kết quả trả về",
                        html: html,
                        icon: "success",
                        showCancelButton: true,
                        confirmButtonText: "Copy",
                        cancelButtonText: "Close"
                    }).then(function(result) {
                        if (result.value) {
                            copyToClipboard(data.data);
                            // copy success reload page
                            setTimeout(function() {
                                location.reload();
                            }, 1000);
                        }
                    });
                }
            }
        })
    } else {
        $('#modalkey').modal('hide');
        Swal.fire("Thông báo", `Số lượng key hiện tại của bạn đã đến giới hạn !`, "error");
        return;
    }
}

function removeKeyExpried() {
    Swal.fire({
        title: 'Xác nhận',
        icon: 'warning',
        text: `Bạn chắc chắn muốn xoá key đã hết hạn ?`,
        showCancelButton: true,
        confirmButtonText: "Xác nhận",
    }).then(function(result) {
        if (result.value) {
            $.ajax({
                url: 'module/ajax-key.php',
                type: 'POST',
                dataType: 'JSON',
                data: {
                    type: 'removeKeyExpried',
                },
                beforeSend: function() {
                    Swal.fire({
                        title: 'Thông báo',
                        text: 'Please wait...',
                        icon: 'info',
                        showConfirmButton: false,
                        allowOutsideClick: false,
                        timerProgressBar: true,
                        didOpen: () => {
                            Swal.showLoading()
                        }
                    })
                },
                success: (data) => {
                    if (data.error) {
                        Swal.fire("Thông báo", data.msg, "error");
                    } else {
                        Swal.fire("Thông báo", data.msg, "success");
                        setTimeout(function() {
                            location.reload();
                        }, 1500);
                    }
                }
            });
        }
    });
}

function rskey(button) {
    var id = button.getAttribute('data-id');
    var keystatus = button.getAttribute('data-keystatus');
    
    if (keystatus != 0) {
        Swal.fire({
            title: 'Xác nhận',
            icon: 'warning',
            text: `Bạn chắc chắn muốn reset key có id ${id} ?`,
            showCancelButton: true,
            confirmButtonText: "Xác nhận",
        }).then(function(result) {
            if (result.value) {
                $.ajax({
                    url: 'module/ajax-key.php',
                    type: 'POST',
                    dataType: 'JSON',
                    data: {
                        type: 'resetkey',
                        key_id: id
                    },
                    beforeSend: function() {
                        Swal.fire({
                            title: 'Thông báo',
                            text: 'Vui lòng chờ...',
                            icon: 'info',
                            showConfirmButton: false,
                            allowOutsideClick: false,
                            timerProgressBar: true,
                            didOpen: () => {
                                Swal.showLoading()
                            }
                        });
                    },
                    success: function(data) {
                        if (data.error) {
                            Swal.fire("Thông báo", data.msg, "error");
                        } else {
                            Swal.fire("Thông báo", data.msg, "success");
                            setTimeout(function() {
                                location.reload();
                            }, 1500);
                        }
                    },
                    error: function(xhr, status, error) {
                        Swal.fire("Error", "Có lỗi xảy ra trong quá trình xử lý.", "error");
                    }
                });
            }
        });
    } else {
        Swal.fire("Thông báo", "Key chưa được kích hoạt!", "error");
    }
}





function setuuid(id, max_uuid) {
  Swal.fire({
    title: 'Cập nhật',
    icon: 'info',
    html: '<span>Số người Dùng</span><input class="swal2-input" value="' + max_uuid + '" id="max_uuid" placeholder="Nhập Số Người Dùng">',
    showCancelButton: true,
    confirmButtonText: 'Cập nhật',
    preConfirm: () => {
      const newMaxUuid = Swal.getPopup().querySelector('#max_uuid').value;
      if (!newMaxUuid) {
        Swal.showValidationMessage('Vui lòng nhập số người dùng');
        return;
      }

      $.ajax({
        url: 'module/ajax-key.php',
        type: 'POST',
        dataType: 'JSON',
        data: {
          type: 'changeuuid',
          key_id: id,
          max_uuid: newMaxUuid
        },
        beforeSend: function() {
          Swal.fire({
            title: 'Thông báo',
            text: 'Please wait...',
            icon: 'info',
            showConfirmButton: false,
            allowOutsideClick: false,
            timerProgressBar: true,
            didOpen: () => {
              Swal.showLoading()
            }
          })
        },
        success: (data) => {
          if (data.error) {
            Swal.fire("Thông báo", data.msg, "error");
          } else {
            Swal.fire("Thông báo", data.msg, "success");
            setTimeout(function() {
              location.reload();
            }, 1500);
          }
        }
      });
    }
  })
}

function genkeyday(soluong) {
  if (soluong < keylimit) {
    let html = `<div class="form-group">
            <label for="key1">Key</label>
            <input type="number" min="1" max="${keylimit - soluong}" value="1" class="form-control" id="key1" name="key1" placeholder="Nhập số key">
        </div>`;

    Swal.fire({
      title: "Tạo key ngày",
      icon: "question",
      html: html,
      showCancelButton: true,
      confirmButtonText: "Xác nhận",
      inputLabel: "Chọn số lượng key ngày bạn muốn tạo",
    }).then((result) => {
      if (result.isConfirmed) {
        let quantity = $("#key1").val();

        $.ajax({
          url: "module/ajax-key.php",
          type: "POST",
          dataType: "JSON",
          data: {
            type: "genkey",
            quantity: quantity,
          },
          success: (data) => {
            if (data.error) {
              Swal.fire("Thông báo", data.msg, "error");
            } else {
              let packageHtml = `<div class="form-group">
                    <label for="package3">Chọn package</label>
                    <select class="form-control" id="package3">
                        <?php
                        $dev = mysqli_query($conn, "SELECT id, debname FROM package WHERE email = '$email' ORDER BY id ASC");
                        $arrDev = array();
                        while ($row = mysqli_fetch_array($dev)) {
                            $arrDev[] = $row;
                        }
                        foreach ($arrDev as $data) {
                            ?>
                            <option value="<?= $data['id'] ?>"><?= $data['debname'] ?></option>
                            <?php
                        }
                        ?>
                    </select>
                </div>`;

              Swal.fire({
                icon: "question",
                title: "Chọn package",
                html: packageHtml,
                showCancelButton: true,
                confirmButtonText: "Xác nhận",
              }).then((packageResult) => {
                if (packageResult.isConfirmed) {
                  let package = $("#package3").val();

                  $.ajax({
                    url: "module/ajax-key.php",
                    type: "POST",
                    dataType: "JSON",
                    data: {
                      type: "genkey",
                      datekey: 1,
                      quantity: quantity,
                      package: package,
                    },
                    beforeSend: function () {
                      Swal.fire({
                        title: "Thông báo",
                        text: "Please wait...",
                        icon: "info",
                        showConfirmButton: false,
                        allowOutsideClick: false,
                        timerProgressBar: true,
                        didOpen: () => {
                          Swal.showLoading();
                        },
                      });
                    },
                    success: (data) => {
                      console.log(data); // Kiểm tra JSON trả về
                      if (data.error) {
                        Swal.fire("Thông báo", data.msg, "error");
                      } else {
                        // disable button create key
                        $("#modalkey").modal("hide");
                        $("#genkeyday").attr("disabled", true);
                        $("#genkeyday").html("Đã tạo key");
                        // show key
                        if (Array.isArray(data.data) && data.data.length > 0) {
                          // Kiểm tra xem có key nào được tạo
                          let html = `
                            <div class="form-group">
                              <label for="key">Key</label>
                              <textarea class="form-control" id="key" rows="3">${data.data.join("\n")}</textarea>
                            </div>
                          `;
                          Swal.fire({
                            title: "Kết quả trả về",
                            html: html,
                            icon: "success",
                            showCancelButton: true,
                            confirmButtonText: "Copy",
                            cancelButtonText: "Close",
                          }).then((result) => {
                            if (result.value) {
                              copyToClipboard(data.data.join("\n"));
                              // copy success reload page
                              setTimeout(() => {
                                location.reload();
                              }, 1000);
                            }
                          });
                        } else {
                          Swal.fire("Thông báo", "Không có key nào được tạo!", "warning");
                        }
                      }
                    },
                  });
                }
              });
            }
          },
        });
      }
    });
  } else {
    Swal.fire("Thông báo", `Số lượng key hiện tại của bạn đã đến giới hạn!`, "error");
    return;
  }
}


function genkeyweek(soluong) {
    if (soluong < keylimit) {
        let html = `<div class="form-group">
            <label for="key1">Key</label>
            <input type="number" min="1" max="${keylimit - soluong}" value="1" class="form-control" id="key1" name="key1" placeholder="Nhập số key">
        </div>`;

        Swal.fire({
            title: "Tạo key tuần",
            icon: "question",
            html: html,
            showCancelButton: true,
            confirmButtonText: "Xác nhận",
            inputLabel: "Chọn số lượng key tuần bạn muốn tạo",
        }).then((result) => {
            if (result.isConfirmed) {
                let quantity = $("#key1").val();

                $.ajax({
                    url: "module/ajax-key.php",
                    type: "POST",
                    dataType: "JSON",
                    data: {
                        type: "genkey",
                        quantity: quantity,
                    },
                    success: (data) => {
                        if (data.error) {
                            Swal.fire("Thông báo", data.msg, "error");
                        } else {
                            let packageHtml = `<div class="form-group">
                                <label for="package3">Chọn package</label>
                                <select class="form-control" id="package3">
                                    <?php
                                    $dev = mysqli_query($conn, "SELECT id, debname FROM package WHERE email = '$email' ORDER BY id ASC");
                                    $arrDev = array();
                                    while ($row = mysqli_fetch_array($dev)) {
                                        $arrDev[] = $row;
                                    }
                                    foreach ($arrDev as $data) {
                                        ?>
                                        <option value="<?= $data['id'] ?>"><?= $data['debname'] ?></option>
                                        <?php
                                    }
                                    ?>
                                </select>
                            </div>`;

                            Swal.fire({
                                icon: "question",
                                title: "Chọn package",
                                html: packageHtml,
                                showCancelButton: true,
                                confirmButtonText: "Xác nhận",
                            }).then((packageResult) => {
                                if (packageResult.isConfirmed) {
                                    let package = $("#package3").val();

                                    $.ajax({
                                        url: "module/ajax-key.php",
                                        type: "POST",
                                        dataType: "JSON",
                                        data: {
                                            type: "genkey",
                                            datekey: 7,
                                            quantity: quantity,
                                            package: package,
                                        },
                                        beforeSend: function () {
                                            Swal.fire({
                                                title: "Thông báo",
                                                text: "Please wait...",
                                                icon: "info",
                                                showConfirmButton: false,
                                                allowOutsideClick: false,
                                                timerProgressBar: true,
                                                didOpen: () => {
                                                    Swal.showLoading();
                                                },
                                            });
                                        },
                                        success: (data) => {
                                            console.log(data); // Kiểm tra JSON trả về
                                            if (data.error) {
                                                Swal.fire("Thông báo", data.msg, "error");
                                            } else {
                                                // disable button create key
                                                $("#modalkey").modal("hide");
                                                $("#genkeyweek").attr("disabled", true);
                                                $("#genkeyweek").html("Đã tạo key");
                                                // show key
                                                if (Array.isArray(data.data) && data.data.length > 0) {
                                                    // Kiểm tra xem có key nào được tạo
                                                    let html = `
                                                        <div class="form-group">
                                                            <label for="key">Key</label>
                                                            <textarea class="form-control" id="key" rows="3">${data.data.join("\n")}</textarea>
                                                        </div>
                                                    `;
                                                    Swal.fire({
                                                        title: "Kết quả trả về",
                                                        html: html,
                                                        icon: "success",
                                                        showCancelButton: true,
                                                        confirmButtonText: "Copy",
                                                        cancelButtonText: "Close",
                                                    }).then((result) => {
                                                        if (result.value) {
                                                            copyToClipboard(data.data.join("\n"));
                                                            // copy success reload page
                                                            setTimeout(() => {
                                                                location.reload();
                                                            }, 1000);
                                                        }
                                                    });
                                                } else {
                                                    Swal.fire("Thông báo", "Không có key nào được tạo!", "warning");
                                                }
                                            }
                                        },
                                    });
                                }
                            });
                        }
                    },
                });
            }
        });
    } else {
        Swal.fire("Thông báo", `Số lượng key hiện tại của bạn đã đến giới hạn!`, "error");
        return;
    }
}



function genkeymonth(soluong) {
    if (soluong < keylimit) {
    let html = `<div class="form-group">
            <label for="key1">Key</label>
            <input type="number" min="1" max="${keylimit - soluong}" value="1" class="form-control" id="key1" name="key1" placeholder="Nhập số key">
        </div>`;

    Swal.fire({
      title: "Tạo key tháng",
      icon: "question",
      html: html,
      showCancelButton: true,
      confirmButtonText: "Xác nhận",
      inputLabel: "Chọn số lượng key tháng bạn muốn tạo",
    }).then((result) => {
      if (result.isConfirmed) {
        let quantity = $("#key1").val();

        $.ajax({
          url: "module/ajax-key.php",
          type: "POST",
          dataType: "JSON",
          data: {
            type: "genkey",
            quantity: quantity,
          },
          success: (data) => {
            if (data.error) {
              Swal.fire("Thông báo", data.msg, "error");
            } else {
              let packageHtml = `<div class="form-group">
                    <label for="package3">Chọn package</label>
                    <select class="form-control" id="package3">
                        <?php
                        $dev = mysqli_query($conn, "SELECT id, debname FROM package WHERE email = '$email' ORDER BY id ASC");
                        $arrDev = array();
                        while ($row = mysqli_fetch_array($dev)) {
                            $arrDev[] = $row;
                        }
                        foreach ($arrDev as $data) {
                            ?>
                            <option value="<?= $data['id'] ?>"><?= $data['debname'] ?></option>
                            <?php
                        }
                        ?>
                    </select>
                </div>`;

              Swal.fire({
                icon: "question",
                title: "Chọn package",
                html: packageHtml,
                showCancelButton: true,
                confirmButtonText: "Xác nhận",
              }).then((packageResult) => {
                if (packageResult.isConfirmed) {
                  let package = $("#package3").val();

                  $.ajax({
                    url: "module/ajax-key.php",
                    type: "POST",
                    dataType: "JSON",
                    data: {
                      type: "genkey",
                      datekey: 30,
                      quantity: quantity,
                      package: package,
                    },
                    beforeSend: function () {
                      Swal.fire({
                        title: "Thông báo",
                        text: "Please wait...",
                        icon: "info",
                        showConfirmButton: false,
                        allowOutsideClick: false,
                        timerProgressBar: true,
                        didOpen: () => {
                          Swal.showLoading();
                        },
                      });
                    },
                    success: (data) => {
                      console.log(data); // Kiểm tra JSON trả về
                      if (data.error) {
                        Swal.fire("Thông báo", data.msg, "error");
                      } else {
                        // disable button create key
                        $("#modalkey").modal("hide");
                        $("#genkeyday").attr("disabled", true);
                        $("#genkeyday").html("Đã tạo key");
                        // show key
                        if (Array.isArray(data.data) && data.data.length > 0) {
                          // Kiểm tra xem có key nào được tạo
                          let html = `
                            <div class="form-group">
                              <label for="key">Key</label>
                              <textarea class="form-control" id="key" rows="3">${data.data.join("\n")}</textarea>
                            </div>
                          `;
                          Swal.fire({
                            title: "Kết quả trả về",
                            html: html,
                            icon: "success",
                            showCancelButton: true,
                            confirmButtonText: "Copy",
                            cancelButtonText: "Close",
                          }).then((result) => {
                            if (result.value) {
                              copyToClipboard(data.data.join("\n"));
                              // copy success reload page
                              setTimeout(() => {
                                location.reload();
                              }, 1000);
                            }
                          });
                        } else {
                          Swal.fire("Thông báo", "Không có key nào được tạo!", "warning");
                        }
                      }
                    },
                  });
                }
              });
            }
          },
        });
      }
    });
  } else {
    Swal.fire("Thông báo", `Số lượng key hiện tại của bạn đã đến giới hạn!`, "error");
    return;
  }
}

function genkeyyear(soluong) {
    if (soluong < keylimit) {
    let html = `<div class="form-group">
            <label for="key1">Key</label>
            <input type="number" min="1" max="${keylimit - soluong}" value="1" class="form-control" id="key1" name="key1" placeholder="Nhập số key">
        </div>`;

    Swal.fire({
      title: "Tạo key năm",
      icon: "question",
      html: html,
      showCancelButton: true,
      confirmButtonText: "Xác nhận",
      inputLabel: "Chọn số lượng key năm bạn muốn tạo",
    }).then((result) => {
      if (result.isConfirmed) {
        let quantity = $("#key1").val();

        $.ajax({
          url: "module/ajax-key.php",
          type: "POST",
          dataType: "JSON",
          data: {
            type: "genkey",
            quantity: quantity,
          },
          success: (data) => {
            if (data.error) {
              Swal.fire("Thông báo", data.msg, "error");
            } else {
              let packageHtml = `<div class="form-group">
                    <label for="package3">Chọn package</label>
                    <select class="form-control" id="package3">
                        <?php
                        $dev = mysqli_query($conn, "SELECT id, debname FROM package WHERE email = '$email' ORDER BY id ASC");
                        $arrDev = array();
                        while ($row = mysqli_fetch_array($dev)) {
                            $arrDev[] = $row;
                        }
                        foreach ($arrDev as $data) {
                            ?>
                            <option value="<?= $data['id'] ?>"><?= $data['debname'] ?></option>
                            <?php
                        }
                        ?>
                    </select>
                </div>`;

              Swal.fire({
                icon: "question",
                title: "Chọn package",
                html: packageHtml,
                showCancelButton: true,
                confirmButtonText: "Xác nhận",
              }).then((packageResult) => {
                if (packageResult.isConfirmed) {
                  let package = $("#package3").val();

                  $.ajax({
                    url: "module/ajax-key.php",
                    type: "POST",
                    dataType: "JSON",
                    data: {
                      type: "genkey",
                      datekey: 365,
                      quantity: quantity,
                      package: package,
                    },
                    beforeSend: function () {
                      Swal.fire({
                        title: "Thông báo",
                        text: "Please wait...",
                        icon: "info",
                        showConfirmButton: false,
                        allowOutsideClick: false,
                        timerProgressBar: true,
                        didOpen: () => {
                          Swal.showLoading();
                        },
                      });
                    },
                    success: (data) => {
                      console.log(data); // Kiểm tra JSON trả về
                      if (data.error) {
                        Swal.fire("Thông báo", data.msg, "error");
                      } else {
                        // disable button create key
                        $("#modalkey").modal("hide");
                        $("#genkeyday").attr("disabled", true);
                        $("#genkeyday").html("Đã tạo key");
                        // show key
                        if (Array.isArray(data.data) && data.data.length > 0) {
                          // Kiểm tra xem có key nào được tạo
                          let html = `
                            <div class="form-group">
                              <label for="key">Key</label>
                              <textarea class="form-control" id="key" rows="3">${data.data.join("\n")}</textarea>
                            </div>
                          `;
                          Swal.fire({
                            title: "Kết quả trả về",
                            html: html,
                            icon: "success",
                            showCancelButton: true,
                            confirmButtonText: "Copy",
                            cancelButtonText: "Close",
                          }).then((result) => {
                            if (result.value) {
                              copyToClipboard(data.data.join("\n"));
                              // copy success reload page
                              setTimeout(() => {
                                location.reload();
                              }, 1000);
                            }
                          });
                        } else {
                          Swal.fire("Thông báo", "Không có key nào được tạo!", "warning");
                        }
                      }
                    },
                  });
                }
              });
            }
          },
        });
      }
    });
  } else {
    Swal.fire("Thông báo", `Số lượng key hiện tại của bạn đã đến giới hạn!`, "error");
    return;
  }
}

 var selectedKeys = [];
    var deleteMode = false; // Biến theo dõi trạng thái "chọn để xóa"

    function toggleDeleteMode() {
        deleteMode = !deleteMode;

        // Thay đổi class của table để hiển thị/ẩn cột checkbox
        var table = document.querySelector('.table');
        table.classList.toggle('delete-mode', deleteMode);

        // Đảo ngược trạng thái hiển thị của nút 'Xác nhận xóa'
        var confirmDeleteButton = document.getElementById('confirm-delete-button');
        confirmDeleteButton.style.display = deleteMode ? 'inline-block' : 'none';

        // Xử lý hiển thị nút
            var selectDeleteButton = document.getElementById('select-delete-button');
            var confirmDeleteButton = document.getElementById('confirm-delete-button');

            if (deleteMode) {
                selectDeleteButton.innerHTML = '<i class="bx bx-x me-1"></i> Thoát';
                confirmDeleteButton.style.display = 'inline-block'; 
            } else {
                selectDeleteButton.innerHTML = '<i class="bx bx-check-circle me-1"></i> Chọn key để xóa';
                confirmDeleteButton.style.display = 'none';
            }

            resetDeleteSelection();
    }
   


    function handleCheckboxChange() {
        selectedKeys = [];
        var checkboxes = document.querySelectorAll('.key-checkbox:checked');
        checkboxes.forEach(function(checkbox) {
            selectedKeys.push(checkbox.value);
        });

        // Kích hoạt/vô hiệu hóa nút Xác nhận xóa dựa trên số lượng checkbox được chọn
        document.getElementById('confirm-delete-button').disabled = selectedKeys.length === 0;
    }

    // Gắn sự kiện change cho tất cả checkbox
    var checkboxes = document.querySelectorAll('.key-checkbox');
    checkboxes.forEach(function(checkbox) {
        checkbox.addEventListener('change', handleCheckboxChange);
    });

    function confirmDeleteKeys() {
        if (selectedKeys.length > 0) {
            Swal.fire({
                title: 'Xác nhận xóa',
                text: `Bạn có chắc chắn muốn xóa ${selectedKeys.length} key đã chọn?`,
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Xóa',
                cancelButtonText: 'Hủy'
            }).then((result) => {
                if (result.isConfirmed) {
                    // Gửi yêu cầu xóa các key đã chọn lên server
                    $.ajax({
                        url: 'module/ajax-key.php',
                        type: 'POST',
                        data: {
                            type: 'deleteSelectedKeys',
                            keyIds: selectedKeys.join(',') // Chuyển mảng thành chuỗi cách nhau bởi dấu phẩy
                        },
                        dataType: 'json',
                        success: function(response) {
                            if (response.error) {
                                Swal.fire('Lỗi!', response.msg, 'error');
                            } else {
                                Swal.fire('Thành công!', response.msg, 'success').then(() => {
                                    
                                    selectedKeys.forEach(function(keyId) {
                                        var row = document.getElementById('key-row-' + keyId);
                                        if (row) {
                                            row.remove();
                                        }
                                    });
                                    // Reset lại lựa chọn xóa và ẩn nút "Xác nhận xóa"
                                    resetDeleteSelection();
                                    setTimeout(function() {
                            location.reload();
                        }, 1500);
                                });
                            }
                        },
                        error: function() {
                            Swal.fire('Lỗi!', 'Đã xảy ra lỗi khi xóa key.', 'error');
                        }
                    });
                }
            });
        }
    }

    function resetDeleteSelection() {
        selectedKeys = [];
        // Bỏ chọn tất cả checkbox
        var checkboxes = document.querySelectorAll('.key-checkbox');
        checkboxes.forEach(function(checkbox) {
            checkbox.checked = false;
        });
        document.getElementById('confirm-delete-button').disabled = true;
    }

    // Hàm thoát chế độ chọn để xóa
    function cancelDeleteMode() {
        toggleDeleteMode(); // Ẩn cột checkbox và các nút
        resetDeleteSelection(); // Bỏ chọn tất cả checkbox
    }
</script>
<script src="/assets/js/pages/anti-f12.js"></script>

</html>


