<?php include 'layouts/session_user.php'; ?>
<?php include 'layouts/head-main.php';

$email = $_SESSION['email'];

$showData = "SELECT * FROM package WHERE email = '$email' ORDER BY id DESC";
$result = mysqli_query($conn, $showData);
$arrShow = [];
while ($row = mysqli_fetch_array($result)) {
    $arrShow[] = $row;
}
?>

<head>
    <title>Package | Unitoreios API</title>
    <?php include 'layouts/head.php'; ?>
    <link href="assets/libs/datatables.net-bs4/css/dataTables.bootstrap4.min.css" rel="stylesheet" type="text/css" />
    <link href="assets/libs/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css" rel="stylesheet" type="text/css" />
    <?php include 'layouts/head-style.php'; ?>
</head>

<?php include 'layouts/body.php'; ?>

<div id="layout-wrapper">
    <?php include 'layouts/menu.php'; ?>

    <div class="main-content">
        <div class="page-content">
            <div class="container-fluid">

                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                            <h4 class="mb-sm-0 font-size-18">Danh sách package</h4>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-lg-12">
                        <div class="card">
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table datatable dt-responsive nowrap" style="width:100%">
                                        <thead>
                                            <tr>
                                                <th>ID</th>
                                                <th>Tên</th>
                                                <th>Version</th>
                                                <th>DebHash</th>
                                                <th>UDID</th>
                                                <th>Trạng thái</th>
                                                <th>More</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($arrShow as $p) { ?>
                                                <tr>
                                                    <td><?php echo $p['id']; ?></td>
                                                    <td><?php echo $p['debname']; ?></td>
                                                    <td><?php echo $p['debversion']; ?></td>
                                                    <td><code><?php echo $p['debhash']; ?></code></td>
                                                    <td><?php echo (isset($p['statusUDID']) && intval($p['statusUDID']) === 1) ? "<span class='badge bg-primary'>On</span>" : "<span class='badge bg-secondary'>Off</span>"; ?></td>
                                                    <td>
                                                        <?php echo (isset($p['debstatus']) && intval($p['debstatus']) === 2) ? "<span class='badge bg-warning'>Maintenance</span>" : "<span class='badge bg-success'>Active</span>"; ?>
                                                    </td>
                                                    <td class="text-end">
                                                        <div class='dropdown'>
                                                            <button class='btn btn-link font-size-16 shadow-none py-0 text-muted dropdown-toggle' type='button' data-bs-toggle='dropdown' aria-expanded='false'>
                                                                <i class='bx bx-dots-horizontal-rounded'></i>
                                                            </button>
                                                            <ul class='dropdown-menu dropdown-menu-end'>
                                                                <li><a class='dropdown-item' href='edit-packageinfo.php?id=<?php echo intval($p['id']); ?>'>Edit</a></li>
                                                                <li><button class='dropdown-item text-danger' onclick="delPackage(<?php echo intval($p['id']); ?>)">Delete</button></li>
                                                            </ul>
                                                        </div>
                                                    </td>
                                                </tr>
                                            <?php } ?>
                                        </tbody>
                                    </table>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>

        <?php include 'layouts/footer.php'; ?>
    </div>
</div>

<?php include 'layouts/right-sidebar.php'; ?>
<?php include 'layouts/vendor-scripts.php'; ?>

<script src="assets/libs/datatables.net/js/jquery.dataTables.min.js"></script>
<script src="assets/libs/datatables.net-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="assets/libs/datatables.net-responsive/js/dataTables.responsive.min.js"></script>
<script src="assets/libs/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js"></script>
<script src="assets/js/app.js"></script>

<script>
function delPackage(id) {
    Swal.fire({
        title: 'Xác nhận',
        icon: 'warning',
        text: `Bạn chắc chắn muốn xoá package có id ${id} ?`,
        showCancelButton: true,
        confirmButtonText: 'Xác nhận',
        cancelButtonText: 'Huỷ',
    }).then(function(result) {
        if (result.value) {
            $.ajax({
                url: 'module/ajax-package.php',
                type: 'POST',
                dataType: 'JSON',
                data: { type: 'delpackage', package_id: id },
                beforeSend: function() {
                    Swal.fire({
                        title: 'Thông báo',
                        text: 'Please wait...',
                        icon: 'info',
                        showConfirmButton: false,
                        allowOutsideClick: false,
                    });
                },
                success: function(res) {
                    if (res && res.error == 0) {
                        Swal.fire({ title: 'Thành công', text: res.msg || 'Đã xoá.', icon: 'success' })
                        .then(() => window.location.reload());
                    } else {
                        Swal.fire({ title: 'Thất bại', text: (res && res.msg) ? res.msg : 'Không thể xoá.', icon: 'error' });
                    }
                },
                error: function() {
                    Swal.fire({ title: 'Thất bại', text: 'Lỗi kết nối.', icon: 'error' });
                }
            });
        }
    });
}
</script>

</body>
</html>
