<?php
session_start();
// Always resolve config relative to this directory to avoid blank-page fatals
require_once(__DIR__ . "/config.php");

// Check if the user is logged in
if (!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true || 
    !isset($_SESSION["email"]) || !isset($_SESSION["username"])) {
    header("location: dangnhap.unitoreios");
    exit;
}

// Thiết lập session bảo mật
ini_set('session.cookie_httponly', 1);
ini_set('session.use_strict_mode', 1);
if (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on') {
    ini_set('session.cookie_secure', 1);
}

$email = $_SESSION['email'];

// Sửa: Truy vấn bằng prepare
$stmt_acc = mysqli_prepare($conn, "SELECT * FROM tai_khoan WHERE email = ?");
mysqli_stmt_bind_param($stmt_acc, "s", $email);
mysqli_stmt_execute($stmt_acc);
$row_acc = u_stmt_fetch_assoc($stmt_acc);
mysqli_stmt_close($stmt_acc);

// Kiểm tra hạn sử dụng
$sql_check_date = "SELECT `date` FROM tai_khoan WHERE email = ? LIMIT 1";
$stmt = mysqli_prepare($conn, $sql_check_date);
mysqli_stmt_bind_param($stmt, "s", $email);
mysqli_stmt_execute($stmt);
$row = u_stmt_fetch_assoc($stmt);
mysqli_stmt_close($stmt);

if ($row) {
    $date = $row['date'];
    // Only enforce expiry when 'date' is set and valid
    if (!empty($date) && strtotime($date) !== false && strtotime($date) < time()) {
        // Chuẩn bị các câu lệnh cập nhật
        $sql_update_quyen = "UPDATE tai_khoan SET quyen = '0' WHERE email = ?";
        $sql_update_package = "UPDATE package SET debstatus = '2' WHERE email = ?";

        // Hàm thực hiện cập nhật
        if (!function_exists('updateStatus')) {
            function updateStatus($conn, $sql, $email) {
                $stmt_update = mysqli_prepare($conn, $sql);
                mysqli_stmt_bind_param($stmt_update, "s", $email);
                mysqli_stmt_execute($stmt_update);
                mysqli_stmt_close($stmt_update);
            }
        }

        updateStatus($conn, $sql_update_quyen, $email);
        updateStatus($conn, $sql_update_package, $email);
    }
}

// Hàm xử lý thời gian
if (!function_exists('time_string')) {
function time_string($datetime, $full = false) {
    if (!$datetime || !strtotime($datetime)) return 'Không rõ thời gian';

    $now = new DateTime;
    $ago = new DateTime($datetime);
    $diff = $now->diff($ago);

    $diff->w = floor($diff->d / 7);
    $diff->d -= $diff->w * 7;

    $string = array(
        'y' => 'năm',
        'm' => 'tháng',
        'w' => 'tuần',
        'd' => 'ngày',
        'h' => 'giờ',
        'i' => 'phút',
        's' => 'giây',
    );
    foreach ($string as $k => &$v) {
        if ($diff->$k) {
            $v = $diff->$k . ' ' . $v;
        } else {
            unset($string[$k]);
        }
    }

    if (!$full) $string = array_slice($string, 0, 1);
    return $string ? implode(', ', $string) . ' trước' : 'Vừa xong';
}
}

// Các hàm keygen
if (!function_exists('basic_keygen')) {
function basic_keygen($level) {
    if ($level == 0) {
        return 'UNIT-' . substr(str_shuffle("0123456789abcdefghijklmnopqrstuvwxyz"), 0, 16);
    } else {
        return $_SESSION["username"] . '-' . substr(str_shuffle("0123456789abcdefghijklmnopqrstuvwxyz"), 0, 16);
    }
}
}

if (!function_exists('days_keygen')) {
function days_keygen($level) {
    return $_SESSION["username"] . '-day-' . substr(str_shuffle("0123456789abcdefghijklmnopqrstuvwxyz"), 0, 16);
}
}

if (!function_exists('week_keygen')) {
function week_keygen($level) {
    return $_SESSION["username"] . '-week-' . substr(str_shuffle("0123456789abcdefghijklmnopqrstuvwxyz"), 0, 16);
}
}

if (!function_exists('month_keygen')) {
function month_keygen($level) {
    return $_SESSION["username"] . '-month-' . substr(str_shuffle("0123456789abcdefghijklmnopqrstuvwxyz"), 0, 16);
}
}

if (!function_exists('year_keygen')) {
function year_keygen($level) {
    return $_SESSION["username"] . '-year-' . substr(str_shuffle("0123456789abcdefghijklmnopqrstuvwxyz"), 0, 16);
}
}
?>