<?php
// Unitoreios DB helper: compatibility for hosts without mysqlnd (no mysqli_stmt_get_result)
if (!function_exists('u_stmt_fetch_assoc')) {
  function u_stmt_fetch_assoc($stmt) {
    $meta = mysqli_stmt_result_metadata($stmt);
    if (!$meta) return null;
    $row = [];
    $params = [$stmt];
    while ($field = mysqli_fetch_field($meta)) {
      $row[$field->name] = null;
      $params[] = &$row[$field->name];
    }
    call_user_func_array('mysqli_stmt_bind_result', $params);
    if (mysqli_stmt_fetch($stmt)) {
      $out = [];
      foreach ($row as $k => $v) $out[$k] = $v;
      return $out;
    }
    return null;
  }

  function u_stmt_fetch_all($stmt) {
    $meta = mysqli_stmt_result_metadata($stmt);
    if (!$meta) return [];
    $row = [];
    $params = [$stmt];
    while ($field = mysqli_fetch_field($meta)) {
      $row[$field->name] = null;
      $params[] = &$row[$field->name];
    }
    call_user_func_array('mysqli_stmt_bind_result', $params);
    $rows = [];
    while (mysqli_stmt_fetch($stmt)) {
      $out = [];
      foreach ($row as $k => $v) $out[$k] = $v;
      $rows[] = $out;
    }
    return $rows;
  }
}
?>