<?php
require_once(__DIR__ . "/config.php");

function updateUserStatus($conn) {
    $current_time = time();
    $sql_get_all_users = "SELECT email, date FROM tai_khoan";
    $result_all_users = mysqli_query($conn, $sql_get_all_users);

    if ($result_all_users && mysqli_num_rows($result_all_users) > 0) {
        while ($row = mysqli_fetch_assoc($result_all_users)) {
            $email = $row['email'];
            $date = $row['date'];

            if (strtotime($date) < $current_time) {
                $sql_update_quyen = "UPDATE tai_khoan SET quyen = '0' WHERE email = ?";
                $sql_update_package = "UPDATE package SET debstatus = '2' WHERE email = ?";

                updateStatus($conn, $sql_update_quyen, $email);
                updateStatus($conn, $sql_update_package, $email);
            }
        }
    }
}

function updateStatus($conn, $sql, $email) {
    $stmt_update = mysqli_prepare($conn, $sql);
    mysqli_stmt_bind_param($stmt_update, "s", $email);
    mysqli_stmt_execute($stmt_update);
    mysqli_stmt_close($stmt_update);
}

while (true) {
    updateUserStatus($conn);
    sleep(60); // Kiểm tra lại sau mỗi 60 giây
}
?>
