<?php
// Unitoreios - One-click Profile Service (.mobileconfig)
// Download straight into iOS Settings (unsigned), no intermediate file.

declare(strict_types=1);

error_reporting(E_ALL);
ini_set('display_errors', '0');
ini_set('zlib.output_compression', '0');
while (ob_get_level()) { @ob_end_clean(); }

header('X-Unitoreios-Install: v22');

function uuid_v4(): string {
    $data = random_bytes(16);
    $data[6] = chr((ord($data[6]) & 0x0f) | 0x40); // version 4
    $data[8] = chr((ord($data[8]) & 0x3f) | 0x80); // variant
    $hex = bin2hex($data);
    return sprintf('%s-%s-%s-%s-%s',
        substr($hex, 0, 8),
        substr($hex, 8, 4),
        substr($hex, 12, 4),
        substr($hex, 16, 4),
        substr($hex, 20, 12)
    );
}

function guess_host(): string {
    $host = $_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '');
    $host = preg_replace('/[^A-Za-z0-9\.\-:]/', '', (string)$host);
    return $host !== '' ? $host : 'localhost';
}

function base_path(): string {
    $scriptName = $_SERVER['SCRIPT_NAME'] ?? '';
    $dir = str_replace('\\', '/', dirname($scriptName));
    $base = rtrim($dir, '/');
    if ($base === '/' || $base === '.') { $base = ''; }
    return $base;
}

function xml_escape(string $s): string {
    return htmlspecialchars($s, ENT_QUOTES | ENT_XML1, 'UTF-8');
}

$id = $_GET['id'] ?? ($_GET['uuid'] ?? ($_POST['id'] ?? ($_POST['uuid'] ?? '')));
if (!is_string($id) || trim($id) === '') {
    http_response_code(400);
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode(['error' => true, 'message' => 'Thiếu thông tin ID'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
    exit;
}

$idreq = preg_replace('/[^a-zA-Z0-9\-_]/', '', trim($id));
if ($idreq === '') {
    http_response_code(400);
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode(['error' => true, 'message' => 'ID không hợp lệ'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
    exit;
}

$host = guess_host();
$scheme = 'https'; // force https
$base = base_path();

$callback = $scheme . '://' . $host . $base . '/processes_data.php?id=' . rawurlencode($idreq);

$payloadUUID = uuid_v4();
$payloadId = 'com.unitoreios.api.udid.' . $idreq . '.' . strtolower(str_replace('-', '', $payloadUUID));

$callbackEsc = xml_escape($callback);
$challengeEsc = xml_escape($idreq);
$payloadUuidEsc = xml_escape($payloadUUID);
$payloadIdEsc = xml_escape($payloadId);

$xml = <<<XML
<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE plist PUBLIC "-//Apple//DTD PLIST 1.0//EN" "http://www.apple.com/DTDs/PropertyList-1.0.dtd">
<plist version="1.0">
<dict>
  <key>PayloadContent</key>
  <dict>
    <key>URL</key>
    <string>{$callbackEsc}</string>
    <key>Challenge</key>
    <string>{$challengeEsc}</string>
    <key>DeviceAttributes</key>
    <array>
      <string>UDID</string>
      <string>VERSION</string>
      <string>PRODUCT</string>
      <string>DEVICE_NAME</string>
    </array>
  </dict>
  <key>PayloadOrganization</key>
  <string>Unitoreios</string>
  <key>PayloadDisplayName</key>
  <string>Unitoreios UDID</string>
  <key>PayloadVersion</key>
  <integer>1</integer>
  <key>PayloadUUID</key>
  <string>{$payloadUuidEsc}</string>
  <key>PayloadIdentifier</key>
  <string>{$payloadIdEsc}</string>
  <key>PayloadDescription</key>
  <string>Cấu hình này dùng để lấy UDID cho Unitoreios API</string>
  <key>PayloadType</key>
  <string>Profile Service</string>
</dict>
</plist>
XML;

header_remove();
header('Content-Type: application/x-apple-aspen-config');
header('Content-Disposition: attachment; filename="unitoreios_udid_' . $idreq . '.mobileconfig"');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');
echo $xml;
exit;
