<?php
declare(strict_types=1);
error_reporting(0);
ini_set('display_errors','0');
header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');
header('X-Unitoreios-Health: v22');

function is_https_request(): bool {
  if (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') return true;
  if (($_SERVER['SERVER_PORT'] ?? '') === '443') return true;
  $xfp = strtolower((string)($_SERVER['HTTP_X_FORWARDED_PROTO'] ?? ''));
  if ($xfp === 'https') return true;
  $xfs = strtolower((string)($_SERVER['HTTP_X_FORWARDED_SSL'] ?? ''));
  if ($xfs === 'on') return true;
  $cfr = (string)($_SERVER['HTTP_CF_VISITOR'] ?? '');
  if ($cfr && stripos($cfr, '"scheme":"https"') !== false) return true;
  $rs = strtolower((string)($_SERVER['REQUEST_SCHEME'] ?? ''));
  if ($rs === 'https') return true;
  return false;
}

$out = [
  'ok' => true,
  'time' => date('c'),
  'https' => is_https_request(),
  'ip' => $_SERVER['REMOTE_ADDR'] ?? '',
  'ua' => $_SERVER['HTTP_USER_AGENT'] ?? '',
  'path' => $_SERVER['REQUEST_URI'] ?? '',
  'php' => PHP_VERSION,
  'sapi' => PHP_SAPI,
  'server' => $_SERVER['SERVER_SOFTWARE'] ?? '',
  'features' => [
    'openssl_ext' => extension_loaded('openssl'),
    'openssl_pkcs7_verify' => function_exists('openssl_pkcs7_verify'),
    'openssl_pkcs7_read' => function_exists('openssl_pkcs7_read'),
    'openssl_x509_parse' => function_exists('openssl_x509_parse'),
    'proc_open' => function_exists('proc_open'),
    'shell_exec' => function_exists('shell_exec'),
    'exec' => function_exists('exec'),
  ],
  'forwarded' => [
    'x_forwarded_proto' => $_SERVER['HTTP_X_FORWARDED_PROTO'] ?? '',
    'x_forwarded_ssl' => $_SERVER['HTTP_X_FORWARDED_SSL'] ?? '',
    'cf_visitor' => $_SERVER['HTTP_CF_VISITOR'] ?? '',
  ]
];

echo json_encode($out, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES);
