<?php
require_once('layouts/config.php');
date_default_timezone_set('Asia/Ho_Chi_Minh');

if (empty($_GET['id']) || empty($_GET['check']) || empty($_GET['idd'])) {
    die("Thiếu thông tin cần thiết từ GET.");
}

$hash = $_GET['id'];
$key = $_GET['check'];
$email = $_GET['idd'];

// Lấy thông tin gói package từ bảng package
$package = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM `package` WHERE `id` = '$hash'"));
if (!$package) {
    die("Gói Package không tồn tại hoặc đã bị xóa.");
}

// Tìm key trong bảng package_key
$key_query = "SELECT * FROM `package_key` WHERE `devicekey` = '$key'";
$key_result = mysqli_query($conn, $key_query);

if ($key_result && mysqli_num_rows($key_result) > 0) {
    // Hiển thị nút nhận key và chỉ cập nhật khi nhấn nút
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        // Nếu người dùng nhấn nút, cập nhật $hash và package_id
        $update_query = "UPDATE `package_key` SET `package_id` = '$hash', `email` = '$email' WHERE `devicekey` = '$key'";
        $update_result = mysqli_query($conn, $update_query);

        if (!$update_result) {
            die("Lỗi khi cập nhật thông tin cho key $key.");
        }
    }
} else {
    die("Không tìm thấy key $key trong cơ sở dữ liệu.");
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta content="width=device-width, initial-scale=1.0" name="viewport">
<title>Thông Tin Thiết Bị</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/11.0.10/sweetalert2.min.css">
<link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i|Raleway:300,300i,400,400i,500,500i,600,600i,700,700i|Poppins:300,300i,400,400i,500,500i,600,600i,700,700i" rel="stylesheet">

<link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/css/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-icons/1.10.5/font/bootstrap-icons.min.css">


<style>
body {
  font-family: "Open Sans", sans-serif;
  color: #444444;
}

a {
  text-decoration: none;
  color: #5a5af3;
}

a:hover {
  color: #2a2af0;
  text-decoration: none;
}

h1,
h2,
h3,
h4,
h5,
h6 {
  font-family: "Raleway", sans-serif;
}

/*--------------------------------------------------------------
# Header
--------------------------------------------------------------*/
#header {
  transition: all 0.5s;
  z-index: 997;
  padding: 20px 0;
  background: #fff;
}

#header.header-scrolled,
#header.header-inner-pages {
  padding: 12px 0;
  box-shadow: 0px 2px 15px rgba(0, 0, 0, 0.1);
}

#header .logo {
  font-size: 32px;
  margin: 0;
  padding: 0;
  line-height: 1;
  font-weight: 700;
  letter-spacing: 2px;
  font-family: "Poppins", sans-serif;
}

#header .logo a {
  color: #5a5af3;
}

#header .logo img {
  max-height: 40px;
}

@media (max-width: 992px) {
  #header {
    padding: 12px 0;
  }
}

/*--------------------------------------------------------------
# Hero Section
--------------------------------------------------------------*/
#hero {
  width: 100%;
  height: 100vh;
  background: white;
  border-bottom: 2px solid white;
}

#hero .container {
  padding-top: 80px;
}

#hero h1 {
  margin: 0;
  font-size: 48px;
  font-weight: 400;
  line-height: 56px;
  color: #434175;
  font-family: "Poppins", sans-serif;
}

#hero h2 {
  margin: 10px 0 0 0;
  font-size: 20px;
}

#hero ul {
  margin-top: 15px;
  list-style: none;
  padding: 0;
}

#hero ul li {
  padding: 10px 0 0 28px;
  position: relative;
}

#hero ul i {
  left: 0;
  top: 7px;
  position: absolute;
  font-size: 20px;
  color: #5a5af3;
}

#hero .btn-get-started,
#hero .btn-get-quote {
  font-family: "Poppins", sans-serif;
  font-weight: 400;
  font-size: 15px;
  letter-spacing: 0.5px;
  display: inline-block;
  padding: 8px 30px 9px 30px;
  margin-bottom: 15px;
  border-radius: 3px;
  transition: 0.5s;
  border-radius: 50px;
}

#hero .btn-get-started {
  background: #5a5af3;
  color: #fff;
  border: 2px solid #5a5af3;
  margin-right: 10px;
}

#hero .btn-get-started:hover {
  background: #7272f5;
  border-color: #7272f5;
}

#hero .btn-get-quote {
  color: #5a5af3;
  border: 2px solid #5a5af3;
}

#hero .btn-get-quote:hover {
  background: #5a5af3;
  color: #fff;
}

@media (min-width: 1024px) {
  #hero {
    background-attachment: fixed;
  }
}

@media (max-width: 991px) {
  #hero .hero-img {
    text-align: center;
  }

  #hero .hero-img img {
    width: 50%;
  }
}

@media (max-width: 768px) {
  #hero h1 {
    font-size: 28px;
    line-height: 36px;
  }

  #hero h2 {
    font-size: 18px;
    line-height: 24px;
    margin-bottom: 30px;
  }

  #hero .hero-img img {
    width: 70%;
  }
}

@media (max-width: 575px) {
  #hero {
    text-align: center;
  }

  #hero ul {
    text-align: left;
    font-size: 14px;
  }

  #hero .hero-img img {
    width: 80%;
  }

  #hero .btn-get-started,
  #hero .btn-get-quote {
    padding-left: 18px;
    padding-right: 18px;
    font-size: 14px;
  }
}

/*--------------------------------------------------------------
# Sections General
--------------------------------------------------------------*/
section {
  padding: 60px 0;
}

.section-bg {
  background-color: #eeeef5;
}

.section-title {
  text-align: center;
  padding-bottom: 30px;
}

.section-title h2 {
  font-size: 32px;
  font-weight: bold;
  text-transform: uppercase;
  margin-bottom: 20px;
  padding-bottom: 20px;
  position: relative;
  color: #434175;
}

.section-title h2::after {
  content: "";
  position: absolute;
  display: block;
  width: 50px;
  height: 3px;
  background: #5a5af3;
  bottom: 0;
  left: calc(50% - 25px);
}

.section-title p {
  margin-bottom: 0;
}

/*--------------------------------------------------------------
# Frequently Asked Questions
--------------------------------------------------------------*/
.faq {
  padding: 60px 0;
}

.faq .faq-list {
  padding: 0;
  list-style: none;
}

.faq .faq-list li {
  border-bottom: 1px solid #f2f2fe;
  margin-bottom: 20px;
  padding-bottom: 20px;
}

.faq .faq-list .question {
  display: block;
  position: relative;
  font-family: #5a5af3;
  font-size: 18px;
  line-height: 24px;
  font-weight: 400;
  padding-left: 25px;
  cursor: pointer;
  color: #2a2af0;
  transition: 0.3s;
}

.faq .faq-list i {
  font-size: 16px;
  position: absolute;
  left: 0;
  top: 2px;
}

.faq .faq-list p {
  margin-bottom: 0;
  padding: 10px 0 0 25px;
}

.faq .faq-list .icon-show {
  display: none;
}

.faq .faq-list .collapsed .icon-show {
  display: inline-block;
}

.faq .faq-list .collapsed .icon-close {
  display: none;
}

/*--------------------------------------------------------------
# Footer
--------------------------------------------------------------*/
#footer {
  color: #555;
  font-size: 14px;
  background: #fff;
  padding: 30px 0;
  border-top: 1px solid #eee;
}

#footer .copyright {
  text-align: center;
  padding-top: 30px;
}

#footer .credits {
  text-align: center;
  font-size: 13px;
  color: #434175;
}

#footer .credits a {
  color: #5a5af3;
}

@media (min-width: 768px) {
  #footer .social-links {
    text-align: right;
  }
}

@media (max-width: 768px) {
  #footer .social-links {
    text-align: center;
    margin-top: 20px;
  }
}

@media (max-width: 768px) {
  #footer .copyright {
    text-align: center;
    padding-top: 30px;
  }
}

/*--------------------------------------------------------------
# Back to top button
--------------------------------------------------------------*/
.back-to-top {
  position: fixed;
  display: none;
  right: 15px;
  bottom: 15px;
  z-index: 996;
}

.back-to-top i {
  display: flex;
  align-items: center;
  justify-content: center;
  font-size: 24px;
  width: 40px;
  height: 40px;
  border-radius: 50%;
  background: #5a5af3;
  color: #fff;
  transition: all 0.4s;
}

.back-to-top i:hover {
  background: #7272f5;
  color: #fff;
}

.modal-content {
  background: linear-gradient(145deg, #fff, #e6e6e6);
  border-radius: 20px;
  box-shadow: 5px 5px 10px #c1c1c1, -5px -5px 10px #ffffff;
}

.modal-header, .modal-footer {
  border-bottom: none;
  border-top: none;
}

.modal-body {
  text-align: center;
}

.modal-body h5 {
  font-size: 24px;
  font-weight: 700;
  color: #5a5af3;
}

.modal-body p {
  font-size: 20px;
}

.btn-primary {
  background: #5a5af3;
  border-color: #5a5af3;
}

.btn-primary:hover {
  background: #7272f5;
  border-color: #7272f5;
}
</style>
</head>
<body>

<!-- Header -->
<header id="header" class="fixed-top d-flex align-items-center">
    <div class="container d-flex align-items-center">
        <div class="logo mr-auto">
            <h1 class="text-light"><a href="home.html"><span>Unitoreios SERVER</span></a></h1>
        </div>
    </div>
</header>

<!-- Hero Section -->
<section id="hero">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-8 text-center">
                <h1>ADMIN Server t.me/APIserie</h1>
                <h2>Nhấn nút bên dưới để nhận key</h2>
                <button type="button" class="btn btn-primary" id="getKeyButton">Nhận Key</button>
            </div>
        </div>
    </div>
</section>

<!-- Modal -->
<div class="modal fade" id="keyModal" tabindex="-1" aria-labelledby="keyModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="keyModalLabel">Key của bạn</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <h5>Key:</h5>
                <p id="keyDisplay"><?php echo htmlspecialchars($key); ?></p>
                <button class="btn btn-secondary" id="copyKeyButton">Copy Key</button>
            </div>
        </div>
    </div>
</div>

<!-- Footer -->
<footer id="footer">
    <div class="container">
        <div class="copyright">
            &copy; Copyright <strong><span>unitoreios</span></strong>. All Rights Reserved
        </div>
        <div class="credits">
            Designed by <a href="https://apiunitoreios.site/Apiunitoreios/">Bạn</a>
        </div>
    </div>
</footer>

<!-- Back to top button -->
<a href="#" class="back-to-top"><i class="bi bi-arrow-up-short"></i></a>

<!-- Scripts -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/js/bootstrap.bundle.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/11.0.10/sweetalert2.min.js"></script>
<script>
document.getElementById('getKeyButton').addEventListener('click', function() {
    var keyModal = new bootstrap.Modal(document.getElementById('keyModal'), {});
    keyModal.show();

    fetch(window.location.href, {
        method: 'POST'
    });

    var keyText = document.getElementById('keyDisplay').innerText;

    // Copy key to clipboard
    document.getElementById('copyKeyButton').addEventListener('click', function() {
        navigator.clipboard.writeText(keyText).then(function() {
            Swal.fire({
                icon: 'success',
                title: 'Đã copy!',
                showConfirmButton: false,
                timer: 1500
            });
        });
    });
});
</script>
</body>
</html>
