<?php
// Unitoreios UDID Tool - get mobileconfig URL
// v20: return direct Profile Service download (install.php) so iOS downloads straight into Settings.
// No intermediate file, no "Not found" from missing udid_profiles files.

declare(strict_types=1);

error_reporting(E_ALL);
ini_set('display_errors', '0');

header('X-Unitoreios-Mobileconfig: v22');

function json_out(array $payload, int $httpCode = 200): void {
    http_response_code($httpCode);
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode($payload, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
    exit;
}

function get_mode(): string {
    $open = $_GET['open'] ?? $_POST['open'] ?? '';
    if ($open === '1' || $open === 'true') return 'open';

    $view = $_GET['view'] ?? $_POST['view'] ?? '';
    if ($view === '1' || $view === 'true') return 'view';

    return 'json';
}

$mode = get_mode();

// Validate input (accept both id and uuid, GET/POST)
$rawId = $_POST['id'] ?? $_GET['id'] ?? $_POST['uuid'] ?? $_GET['uuid'] ?? '';
if (!is_string($rawId) || trim($rawId) === '') {
    json_out(['error' => true, 'message' => 'Thiếu thông tin ID'], 400);
}

$idreq = preg_replace('/[^a-zA-Z0-9\-_]/', '', trim($rawId));
if ($idreq === '') {
    json_out(['error' => true, 'message' => 'ID không hợp lệ'], 400);
}

$host = $_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '');
$host = preg_replace('/[^A-Za-z0-9\.\-:]/', '', (string)$host);
if ($host === '') {
    json_out(['error' => true, 'message' => 'Không xác định được host'], 500);
}

$scheme = 'https';
$scriptName = $_SERVER['SCRIPT_NAME'] ?? '';
$scriptDir  = str_replace('\\', '/', dirname($scriptName));
$basePath   = rtrim($scriptDir, '/');
if ($basePath === '/' || $basePath === '.') { $basePath = ''; }

$installUrl = $scheme . '://' . $host . $basePath . '/install.php?id=' . rawurlencode($idreq);

// open=1: redirect to direct .mobileconfig download (Safari will show "Hồ sơ đã tải về")
if ($mode === 'open') {
    header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
    header('Pragma: no-cache');
    header('Location: ' . $installUrl, true, 302);
    exit;
}

// view=1: show a nice page with a download button
if ($mode === 'view') {
    header('Content-Type: text/html; charset=utf-8');
    header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
    header('Pragma: no-cache');
    $safeUrl = htmlspecialchars($installUrl, ENT_QUOTES, 'UTF-8');
    echo '<!doctype html><html><head><meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">'
        . '<title>Unitoreios UDID</title>'
        . '<style>body{font-family:-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,Arial,sans-serif;margin:0;background:#0b1220;color:#e5e7eb}'
        . '.wrap{max-width:520px;margin:0 auto;padding:28px}.card{background:#111827;border:1px solid #1f2937;border-radius:16px;padding:18px}'
        . 'h1{font-size:20px;margin:0 0 10px}p{margin:10px 0;color:#cbd5e1;line-height:1.5}'
        . '.btn{display:block;text-align:center;background:#5a5af3;color:#fff;padding:14px 16px;border-radius:12px;font-weight:700;text-decoration:none;margin-top:14px}'
        . '.sub{font-size:12px;color:#93a4b8;margin-top:10px;word-break:break-all}</style>'
        . '</head><body><div class="wrap"><div class="card">'
        . '<h1>Unitoreios UDID</h1>'
        . '<p>Bấm nút bên dưới để tải hồ sơ cài đặt. Sau đó vào <b>Cài đặt</b> để cài hồ sơ.</p>'
        . '<a class="btn" href="' . $safeUrl . '">Tải hồ sơ (.mobileconfig)</a>'
        . '<div class="sub">Link: ' . $safeUrl . '</div>'
        . '</div></div></body></html>';
    exit;
}

// Default: JSON API
json_out([
    'error' => false,
    'mobileconfig' => $installUrl,
    'signed' => false,
    'message' => 'Đã tắt ký mobileconfig, đang dùng bản unsigned.'
]);
