<?php
// Unitoreios: Edit Package (Admin/User)
// - Admin can edit any package
// - User can only edit own package

require_once __DIR__ . '/layouts/session.php';
require_once __DIR__ . '/layouts/head-main.php';

$email = $_SESSION['email'] ?? '';

// Get role
$stmt = mysqli_prepare($conn, "SELECT quyen FROM tai_khoan WHERE email = ? LIMIT 1");
mysqli_stmt_bind_param($stmt, "s", $email);
mysqli_stmt_execute($stmt);
$rowRole = u_stmt_fetch_assoc($stmt);
mysqli_stmt_close($stmt);
$role = intval($rowRole['quyen'] ?? 0);

$pkg_id = intval($_GET['id'] ?? ($_POST['id'] ?? 0));
if ($pkg_id <= 0) {
    header('location: danh-sach-package.unitoreios');
    exit;
}

// Fetch package
function fetch_pkg($conn, $id) {
    $stmt = mysqli_prepare($conn, "SELECT * FROM package WHERE id = ? LIMIT 1");
    mysqli_stmt_bind_param($stmt, "i", $id);
    mysqli_stmt_execute($stmt);
    $pkg = u_stmt_fetch_assoc($stmt);
    mysqli_stmt_close($stmt);
    return $pkg;
}

$pkg = fetch_pkg($conn, $pkg_id);
if (!$pkg) {
    header('location: pages-404.php');
    exit;
}

// Permission
if ($role !== 1 && ($pkg['email'] ?? '') !== $email) {
    header('location: pages-404.php');
    exit;
}

$err = '';
$ok = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Input sanitize
    $debname = trim($_POST['debname'] ?? '');
    $debversion = trim($_POST['debversion'] ?? '');
    $newdeblink = trim($_POST['newdeblink'] ?? '');
    $debupdatenoti = trim($_POST['debupdatenoti'] ?? '');
    $debcontact = trim($_POST['debcontact'] ?? '');
    $linkmod = trim($_POST['linkmod'] ?? '');
    $colorcode = trim($_POST['colorcode'] ?? '');
    $statusUDID = intval($_POST['statusUDID'] ?? 1);
    $hashcheck = intval($_POST['hashcheck'] ?? 0);

    if ($debname === '') {
        $err = 'Tên package không được để trống.';
    } else {
        // Normalize small limits to prevent abuse
        if (strlen($debname) > 255) $debname = substr($debname, 0, 255);
        if (strlen($debversion) > 64) $debversion = substr($debversion, 0, 64);
        if (strlen($colorcode) > 32) $colorcode = substr($colorcode, 0, 32);

        $statusUDID = ($statusUDID === 1) ? 1 : 0;
        $hashcheck  = ($hashcheck === 1) ? 1 : 0;

        $stmt = mysqli_prepare($conn, "UPDATE package
            SET debname = ?, debversion = ?, newdeblink = ?, debupdatenoti = ?, debcontact = ?, linkmod = ?, colorcode = ?, statusUDID = ?, hashcheck = ?
            WHERE id = ? LIMIT 1");
        if (!$stmt) {
            $err = 'Lỗi hệ thống: không thể tạo câu lệnh SQL.';
        } else {
            mysqli_stmt_bind_param($stmt, "sssssssiii",
                $debname, $debversion, $newdeblink, $debupdatenoti, $debcontact, $linkmod, $colorcode, $statusUDID, $hashcheck, $pkg_id
            );
            if (mysqli_stmt_execute($stmt)) {
                $ok = 'Cập nhật package thành công.';
                $pkg = fetch_pkg($conn, $pkg_id); // reload
            } else {
                $err = 'Cập nhật thất bại. Vui lòng thử lại.';
            }
            mysqli_stmt_close($stmt);
        }
    }
}
?>
<head>
    <title>Edit Package | Unitoreios API</title>
    <?php include 'layouts/head.php'; ?>
    <?php include 'layouts/head-style.php'; ?>
</head>

<?php include 'layouts/body.php'; ?>

<div id="layout-wrapper">
    <?php include 'layouts/menu.php'; ?>

    <div class="main-content">
        <div class="page-content">
            <div class="container-fluid">

                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                            <h4 class="mb-sm-0 font-size-18">Chỉnh sửa package</h4>
                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a href="javascript:void(0);">Menu</a></li>
                                    <li class="breadcrumb-item active">Edit Package</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>

                <?php if ($err) { ?>
                    <div class="alert alert-danger"><?php echo htmlspecialchars($err); ?></div>
                <?php } ?>
                <?php if ($ok) { ?>
                    <div class="alert alert-success"><?php echo htmlspecialchars($ok); ?></div>
                <?php } ?>

                <div class="row">
                    <div class="col-lg-12">
                        <div class="card">
                            <div class="card-body">

                                <form method="POST" action="edit-packageinfo.php">
                                    <input type="hidden" name="id" value="<?php echo intval($pkg['id']); ?>">

                                    <div class="row">
                                        <div class="col-md-6 mb-3">
                                            <label class="form-label">Tên package</label>
                                            <input type="text" name="debname" class="form-control" required value="<?php echo htmlspecialchars($pkg['debname'] ?? ''); ?>">
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <label class="form-label">Version</label>
                                            <input type="text" name="debversion" class="form-control" value="<?php echo htmlspecialchars($pkg['debversion'] ?? ''); ?>">
                                        </div>
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label">Link package (newdeblink)</label>
                                        <input type="text" name="newdeblink" class="form-control" value="<?php echo htmlspecialchars($pkg['newdeblink'] ?? ''); ?>">
                                    </div>

                                    <div class="row">
                                        <div class="col-md-6 mb-3">
                                            <label class="form-label">UDID check</label>
                                            <select name="statusUDID" class="form-select">
                                                <option value="1" <?php echo (intval($pkg['statusUDID'] ?? 1) === 1) ? 'selected' : ''; ?>>On</option>
                                                <option value="0" <?php echo (intval($pkg['statusUDID'] ?? 1) === 0) ? 'selected' : ''; ?>>Off</option>
                                            </select>
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <label class="form-label">Kiểm tra tài nguyên (hashcheck)</label>
                                            <select name="hashcheck" class="form-select">
                                                <option value="1" <?php echo (intval($pkg['hashcheck'] ?? 0) === 1) ? 'selected' : ''; ?>>On</option>
                                                <option value="0" <?php echo (intval($pkg['hashcheck'] ?? 0) === 0) ? 'selected' : ''; ?>>Off</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label">Update note (debupdatenoti)</label>
                                        <textarea name="debupdatenoti" rows="3" class="form-control"><?php echo htmlspecialchars($pkg['debupdatenoti'] ?? ''); ?></textarea>
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label">Contact (debcontact)</label>
                                        <textarea name="debcontact" rows="2" class="form-control"><?php echo htmlspecialchars($pkg['debcontact'] ?? ''); ?></textarea>
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label">Link mod (linkmod)</label>
                                        <textarea name="linkmod" rows="2" class="form-control"><?php echo htmlspecialchars($pkg['linkmod'] ?? ''); ?></textarea>
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label">Color code (optional)</label>
                                        <input type="text" name="colorcode" class="form-control" value="<?php echo htmlspecialchars($pkg['colorcode'] ?? ''); ?>" placeholder="#ff0000">
                                    </div>

                                    <div class="d-flex gap-2">
                                        <button type="submit" class="btn btn-primary">Lưu thay đổi</button>
                                        <?php if ($role === 1) { ?>
                                            <a class="btn btn-light" href="admin-package.unitoreios">Quay lại danh sách</a>
                                        <?php } else { ?>
                                            <a class="btn btn-light" href="danh-sach-package.unitoreios">Quay lại danh sách</a>
                                        <?php } ?>
                                    </div>

                                    <hr class="my-4">

                                    <div class="alert alert-info mb-0">
                                        <div><b>DebHash (SHA1/MD5 lưu trong DB):</b> <code><?php echo htmlspecialchars($pkg['debhash'] ?? ''); ?></code></div>
                                        <div class="mt-2">Muốn đổi DebHash thì dùng chức năng <b>Change SHA1</b> ở trang admin.</div>
                                    </div>

                                </form>

                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>

        <?php include 'layouts/footer.php'; ?>
    </div>
</div>

<?php include 'layouts/right-sidebar.php'; ?>
<?php include 'layouts/vendor-scripts.php'; ?>
<script src="assets/js/app.js"></script>
</body>
</html>
