<?php
// Unitoreios: Serve .mobileconfig with correct MIME/headers for iOS.
// Usage: download_mobileconfig.php?f=<filename.mobileconfig>

declare(strict_types=1);

error_reporting(0);
ini_set('display_errors', '0');
ini_set('zlib.output_compression', '0');
while (ob_get_level()) { @ob_end_clean(); }
header_remove();
header('X-Unitoreios-Download: v22');

$outDir = __DIR__ . '/udid_profiles';

$f = $_GET['f'] ?? '';
if (!is_string($f) || $f === '') {
    http_response_code(400);
    exit('Missing f');
}

// Only allow safe basenames.
$f = basename($f);
if (!preg_match('/^[a-zA-Z0-9_\-\.]+\.mobileconfig$/', $f)) {
    http_response_code(400);
    exit('Invalid f');
}

$path = $outDir . '/' . $f;
if (!is_file($path) || !is_readable($path)) {
    // Fuzzy recovery: if user copied a truncated filename (common on mobile),
    // try to find the real file by prefix within the last hour.
    $stem = preg_replace('/\.mobileconfig$/', '', $f);
    if ($stem !== $f) {
        $glob = glob($outDir . '/' . $stem . '*.mobileconfig') ?: [];
        $cand = [];
        foreach ($glob as $g) {
            $bn = basename($g);
            if (preg_match('/^[a-zA-Z0-9_\-\.]+\.mobileconfig$/', $bn) && is_readable($g)) {
                // only accept very recent files to avoid serving wrong content
                if (time() - @filemtime($g) <= 3600) {
                    $cand[] = $g;
                }
            }
        }
        if (count($cand) === 1) {
            $path = $cand[0];
            $f = basename($path);
            header('X-Unitoreios-Download-Match: fuzzy');
        } else {
            http_response_code(404);
            exit('Not found');
        }
    } else {
        http_response_code(404);
        exit('Not found');
    }
} else {
    header('X-Unitoreios-Download-Match: exact');
}

header('Content-Type: application/x-apple-aspen-config');
header('Content-Disposition: attachment; filename="' . $f . '"');
header('Content-Length: ' . filesize($path));
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');

readfile($path);
exit;
