<?php
require_once('layouts/config.php');
include 'layouts/session.php';
$email = $_SESSION['email'];

// --- Unitoreios: Auto duyệt bank (Casso) + tự cộng hạn mức theo gói ---

function unitoreios_get_setting($conn, $key, $default = null) {
    $sql = "SELECT `$key` FROM `websetting` WHERE `id` = 1 LIMIT 1";
    $rs = @mysqli_query($conn, $sql);
    if ($rs && mysqli_num_rows($rs) > 0) {
        $row = mysqli_fetch_assoc($rs);
        if (isset($row[$key]) && $row[$key] !== '' && $row[$key] !== null) return $row[$key];
    }
    return $default;
}

function unitoreios_plan_map($plan) {
    $plans = [
        '50k'  => ['amount' => 50000,  'pkg' => 2,  'create' => 5,  'key_total' => 200, 'uuid' => 100],
        '100k' => ['amount' => 100000, 'pkg' => 5,  'create' => 10, 'key_total' => 350, 'uuid' => 200],
        '150k' => ['amount' => 150000, 'pkg' => 7,  'create' => 15, 'key_total' => 420, 'uuid' => 250],
        '200k' => ['amount' => 200000, 'pkg' => 10, 'create' => 20, 'key_total' => 500, 'uuid' => 300],
    ];
    return $plans[$plan] ?? null;
}

function unitoreios_table_exists($conn, $table) {
    $table = mysqli_real_escape_string($conn, $table);
    $rs = mysqli_query($conn, "SHOW TABLES LIKE '$table'");
    return $rs && mysqli_num_rows($rs) > 0;
}

function unitoreios_apply_plan($conn, $email, $planCode, $amount) {
    $plan = unitoreios_plan_map($planCode);
    if (!$plan) return ['ok' => false, 'message' => 'Gói không hợp lệ'];

    // cộng tiền + hạn mức + gia hạn 30 ngày (cộng dồn nếu còn hạn)
    $pkgAdd = (int)$plan['pkg'];
    $keyTotalAdd = (int)$plan['key_total'];
    $createLimit = (int)$plan['create'];
    $uuidLimit = (int)$plan['uuid'];
    $email = (string)$email;

    $sql = "UPDATE `tai_khoan`
            SET `money` = `money` + ?,
                `package_limit` = `package_limit` + ?,
                `keylimit` = `keylimit` + ?,
                `countkey` = 0,
                `countkeylimit` = ?,
                `uuid_limit` = ?,
                `date` = CASE
                    WHEN `date` IS NULL OR `date` < NOW() THEN DATE_ADD(NOW(), INTERVAL 30 DAY)
                    ELSE DATE_ADD(`date`, INTERVAL 30 DAY)
                END
            WHERE `email` = ?";

    $stmt = $conn->prepare($sql);
    if (!$stmt) return ['ok' => false, 'message' => 'SQL prepare failed: ' . $conn->error];
    $stmt->bind_param('iiiiis', $amount, $pkgAdd, $keyTotalAdd, $createLimit, $uuidLimit, $email);
    $stmt->execute();
    if ($stmt->error) return ['ok' => false, 'message' => 'SQL error: ' . $stmt->error];
    return ['ok' => true, 'message' => 'ok'];
}

function check_string($data)
{
    return trim(htmlspecialchars(addslashes($data)));
}

function customUrlDecode($value)
{
    $value = str_replace('%2B', ' ', $value);
    // Add more decoding rules here if needed
    return $value;
}

if (isset($_POST['submit'])) {
    $name = check_string($_POST['name']);
    $stk = check_string($_POST['stk']);
    $planCode = isset($_POST['plan']) ? check_string($_POST['plan']) : '';
    $plan = unitoreios_plan_map($planCode);
    // chống sửa tiền: tiền theo plan
    $money = $plan ? (int)$plan['amount'] : (int)check_string($_POST['money']);
    $tentk = urlencode(check_string($_POST['tentk']));
    $nd = urlencode(check_string($_POST['nd']));
    $temp = check_string($_POST['temp']);
    if (!$name) {
        echo 'Bạn chưa chọn ngân hàng';
    } else if (!$stk) {
        echo 'Bạn chưa điền số tài khoản';
    } else {
        $url = "https://img.vietqr.io/image/$name-$stk-$temp.png?amount=$money&addInfo=$nd&accountName=$tentk";

        // tạo order pending để auto duyệt & chống cộng lại
        $createdOrderId = 0;
        if (unitoreios_table_exists($conn, 'bank_orders') && $plan) {
            $contentDecoded = urldecode($nd);
            $stmtOrd = $conn->prepare("INSERT INTO `bank_orders` (`email`,`plan_code`,`amount`,`content`,`status`,`created_at`) VALUES (?,?,?,?,0,NOW())");
            if ($stmtOrd) {
                $amt = (int)$money;
                $stmtOrd->bind_param('ssis', $email, $planCode, $amt, $contentDecoded);
                $stmtOrd->execute();
                if (!$stmtOrd->error) {
                    $createdOrderId = (int)$conn->insert_id;
                }
            }
        }
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['type']) && $_POST['type'] === 'genbank') {
    
    $noidung = check_string($_POST['noidung']);
    $giatien = (int)check_string($_POST['giatien']);
    $planCode = isset($_POST['plan']) ? check_string($_POST['plan']) : '';
    $orderId = isset($_POST['order_id']) ? (int)$_POST['order_id'] : 0;

    // validate plan (giatien sẽ được đối chiếu đúng amount của plan)
    $plan = unitoreios_plan_map($planCode);
    if (!$plan) {
        echo json_encode(['error' => 1, 'message' => 'Gói không hợp lệ']);
        exit;
    }
    if ((int)$plan['amount'] !== (int)$giatien) {
        echo json_encode(['error' => 1, 'message' => 'Số tiền không khớp gói']);
        exit;
    }

    $curl = curl_init();
    // Casso API key: ưu tiên lấy từ websetting.casso_api_key (nếu có), fallback key cũ để không gãy hệ thống
    $cassoKey = unitoreios_get_setting($conn, 'casso_api_key', 'AK_CS.b9308b4042a811ef90c3c9ff66e60f20.xKNORXIThFMsJCR2nKKWlE7rrftpIbjpNVlFrvLJxwQthkYVSOxY083uiihXJ9FsfoHxdWba');

    curl_setopt_array($curl, array(
        CURLOPT_URL => "https://oauth.casso.vn/v2/transactions/?pageSize=200",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_CUSTOMREQUEST => "GET",
        CURLOPT_HTTPHEADER => array(
            "Authorization: Apikey $cassoKey",
            "Content-Type: application/json"
        ),
    ));

    $response = curl_exec($curl);
    $err = curl_error($curl);
    curl_close($curl);

    if ($err) {
        echo json_encode(['error' => 1, 'message' => "cURL Error #:" . $err]);
        exit;
    }

    $response_data = json_decode($response, true);

    if (isset($response_data['message']) && $response_data['message'] == 'success') {
        $response_minidata = json_encode($response_data['data']);
        $decode_data = json_decode($response_minidata, true);

        if (isset($decode_data['records'])) {
            $found = false;
            $foundRecord = null;

            foreach ($decode_data['records'] as $record) {
                $desc = isset($record['description']) ? trim((string)$record['description']) : '';
                $amt  = isset($record['amount']) ? (int)$record['amount'] : 0;
                if ($desc === (string)$noidung && $amt === (int)$giatien) {
                    $found = true;
                    $foundRecord = $record;
                    break;
                }
            }

            if ($found) {
                $txnId = null;
                if (is_array($foundRecord)) {
                    if (isset($foundRecord['id'])) $txnId = (string)$foundRecord['id'];
                    else if (isset($foundRecord['tid'])) $txnId = (string)$foundRecord['tid'];
                }
                if (!$txnId) $txnId = sha1($noidung . '|' . $giatien);

                // chống cộng lại (id giao dịch đã xử lý)
                if (unitoreios_table_exists($conn, 'bank_transactions')) {
                    $stmtCheck = $conn->prepare("SELECT `id` FROM `bank_transactions` WHERE `txn_id` = ? LIMIT 1");
                    $stmtCheck->bind_param('s', $txnId);
                    $stmtCheck->execute();
                    $rs = $stmtCheck->get_result();
                    if ($rs && $rs->num_rows > 0) {
                        echo json_encode(['error' => 0, 'message' => 'already']);
                        exit;
                    }
                }

                // ghi nhận giao dịch
                if (unitoreios_table_exists($conn, 'bank_transactions')) {
                    $stmtIns = $conn->prepare("INSERT INTO `bank_transactions` (`email`,`order_id`,`plan_code`,`amount`,`content`,`txn_id`,`created_at`) VALUES (?,?,?,?,?,?,NOW())");
                    $stmtIns->bind_param('sisiss', $email, $orderId, $planCode, $giatien, $noidung, $txnId);
                    $stmtIns->execute();
                }

                // update order
                if ($orderId > 0 && unitoreios_table_exists($conn, 'bank_orders')) {
                    $stmtOrd = $conn->prepare("UPDATE `bank_orders` SET `status`=1, `paid_at`=NOW(), `txn_id`=? WHERE `id`=? AND `email`=?");
                    $stmtOrd->bind_param('sis', $txnId, $orderId, $email);
                    $stmtOrd->execute();
                }

                // Apply plan (cộng quota + gia hạn)
                $ap = unitoreios_apply_plan($conn, $email, $planCode, $giatien);
                if (!$ap['ok']) {
                    echo json_encode(['error' => 1, 'message' => $ap['message']]);
                } else {
                    echo json_encode(['error' => 0, 'message' => 'ok']);
                }
            } else {
                echo json_encode(['error' => 1, 'message' => 'Không tìm thấy bản ghi khớp']);
            }
        } else {
            echo json_encode(['error' => 1, 'message' => 'Không có bản ghi nào trong dữ liệu']);
        }
    } else {
        echo json_encode(['error' => 1, 'message' => 'Error in response: ' . json_encode($response_data)]);
    }
    exit;
}
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>API server BANKING</title>
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.1.1/css/bootstrap.min.css"
          integrity="sha384-WskhaSGFgHYWDcbwN70/dfYBj47jz9qbsMId/iRN3ewGhXQFZCSftd1LZCfmhktB" crossorigin="anonymous">
    <style>
        #loading {
            display: none;
        }

        #countdown {
            font-size: 24px;
            color: red;
        }
    </style>
</head>
<body>
<?php if (isset($url)): ?>
    <center>
        <img src="<?= $url; ?>">
        <div id="loading">
            <h5>Đợi hệ thống xác nhận</h5>
            <div class="spinner-border" role="status">
                <span class="sr-only">Loading...</span>
            </div>
            <div id="countdown"></div>
        </div>
        <!-- Button to trigger modal -->
        <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#confirmPaymentModal" id="confirmPaymentButton"
                style="display: none;">
            Yêu Cầu Xác Nhận Thanh Toán
        </button>
        
    </center>
<?php endif; ?>

<!-- Modal -->
<div class="modal fade" id="confirmPaymentModal" tabindex="-1" role="dialog" aria-labelledby="confirmPaymentModalLabel"
     aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="confirmPaymentModalLabel">Xác nhận thanh toán</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="paymentForm">
                    <div class="form-group">
                        <label for="noidung">Nội dung giao dịch:</label>
                        <input type="text" class="form-control" id="noidung" name="noidung" readonly>
                    </div>
                    <div class="form-group">
                        <label for="giatien">Giá tiền:</label>
                        <input type="text" class="form-control" id="giatien" name="giatien" readonly>
                    </div>
                    <div id="paymentMessage" class="alert" style="display: none;"></div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Đóng</button>
                <button type="button" class="btn btn-primary" id="confirmPaymentBtn">Xác nhận thanh toán</button>
            </div>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.3.1.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.3/umd/popper.min.js"
        integrity="sha384-ZMP7rVo3mIykV+2+9J3UJ46jBk0WLaUAdn689aCwoqbBJiSnjAK/l8WvCWPIPm49"
        crossorigin="anonymous"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.1.1/js/bootstrap.min.js"
        integrity="sha384-smHYKdLADwkXOn1EmN1qk/HfnUcbVRZyYmZ4qpPea6sjB/pTJ0euyQp0Mk8ck+5T"
        crossorigin="anonymous"></script>
<script>
    $(document).ready(function () {
        // --- AUTO DUYỆT BANK ---
        var expectedContent = "<?php echo isset($_POST['nd']) ? addslashes(customUrlDecode($_POST['nd'])) : ''; ?>";
        var expectedAmount  = <?php echo isset($money) ? (int)$money : 0; ?>;
        var planCode        = "<?php echo isset($_POST['plan']) ? addslashes(check_string($_POST['plan'])) : ''; ?>";
        var orderId         = <?php echo isset($createdOrderId) ? (int)$createdOrderId : 0; ?>;

        // populate hidden modal fields for debugging
        $('#noidung').val(expectedContent);
        $('#giatien').val(expectedAmount);

        var countdownTime = 10 * 60; // 10 phút
        var countdownElement = document.getElementById('countdown');
        var loadingElement = document.getElementById('loading');

        function tickCountdown() {
            var minutes = Math.floor(countdownTime / 60);
            var seconds = countdownTime % 60;
            if (countdownElement) countdownElement.textContent = minutes + ":" + (seconds < 10 ? '0' : '') + seconds;
            countdownTime--;
        }

        function verifyPaymentOnce() {
            if (!expectedContent || !expectedAmount || !planCode) return;
            $.ajax({
                type: 'POST',
                url: '',
                dataType: 'json',
                data: {
                    type: 'genbank',
                    giatien: expectedAmount,
                    noidung: expectedContent,
                    plan: planCode,
                    order_id: orderId
                },
                success: function (response) {
                    if (response && response.error == 0) {
                        // paid -> redirect
                        window.history.replaceState({}, document.title, window.location.pathname);
                        setTimeout(function () {
                            window.location.href = 'nang-cap.unitoreios?paid=1';
                        }, 500);
                    }
                }
            });
        }

        if (loadingElement) {
            loadingElement.style.display = 'block';

            // gọi kiểm tra ngay + định kỳ 5s
            verifyPaymentOnce();
            var poll = setInterval(function () {
                if (countdownTime <= 0) {
                    clearInterval(poll);
                    if (loadingElement) loadingElement.style.display = 'none';
                    return;
                }
                tickCountdown();
                // mỗi 5 giây check 1 lần
                if (countdownTime % 5 === 0) verifyPaymentOnce();
            }, 1000);
        }
    });
</script>
</body>
</html>
