<?php 
include 'layouts/session.php'; 
include 'layouts/head-main.php';

$email = $_SESSION['email'] ?? 'example@abc.com'; // hoặc lấy từ session, biến truyền từ backend
?>

<head>
    <title>Verification | Unitoreios API APIserie </title>
    <?php include 'layouts/head.php'; ?>
    <?php include 'layouts/head-style.php'; ?>
    <link href="assets/libs/sweetalert2/sweetalert2.min.css" rel="stylesheet" />
</head>

<?php include 'layouts/body.php'; ?>

<div class="auth-page">
    <div class="container-fluid p-0">
        <div class="row g-0 justify-content-center">
            <div class="col-xxl-3 col-lg-4 col-md-5">
                <div class="auth-full-page-content d-flex p-sm-5 p-4">
                    <div class="w-100">
                        <div class="d-flex flex-column h-100">
                            <div class="mb-4 mb-md-5 text-center">
                                <a href="home.html" class="d-block auth-logo">
                                    <img src="assets/images/logo-new.png" alt="" height="40"> 
                                    <span class="logo-txt">Unitoreios API</span>
                                </a>
                            </div>
                            <div class="auth-content my-auto">
                                <div class="text-center">

                                    <div class="avatar-lg mx-auto">
                                        <div class="avatar-title rounded-circle bg-light">
                                            <i class="bx bxs-envelope h2 mb-0 text-primary"></i>
                                        </div>
                                    </div>
                                    <div class="p-2 mt-4">

                                        <h4>Verify your email</h4>
                                        <p class="mb-5">Please enter the 4 digit code sent to <span class="fw-bold"><?=htmlspecialchars($email)?></span></p>

                                        <form id="verify-form" onsubmit="return false;">
                                            <div class="row">
                                                <?php
                                                for ($i=1; $i<=4; $i++):
                                                ?>
                                                <div class="col-3">
                                                    <div class="mb-3">
                                                        <label for="digit<?=$i?>-input" class="visually-hidden">Digit <?=$i?></label>
                                                        <input type="text" 
                                                            class="form-control form-control-lg text-center digit-input" 
                                                            onkeyup="moveToNext(this, <?= $i == 4 ? 4 : $i + 1 ?>)" 
                                                            maxlength="1" 
                                                            id="digit<?=$i?>-input"
                                                            pattern="[0-9]" inputmode="numeric"
                                                            autocomplete="one-time-code"
                                                            required>
                                                    </div>
                                                </div>
                                                <?php endfor; ?>
                                            </div>
                                        </form>

                                        <div class="mt-4">
                                            <button id="btn-confirm" class="btn btn-primary w-100">Confirm</button>
                                        </div>
                                    </div>

                                </div>

                                <div class="mt-5 text-center">
                                    <p class="text-muted mb-0">Nếu không nhận được mã, vui lòng kiểm tra trong mục spam hoặc 
                                        <a href="#" id="resend-code" class="text-primary fw-semibold">Gửi lại</a> 
                                    </p>
                                </div>
                            </div>
                            <div class="mt-4 mt-md-5 text-center">
                                <p class="mb-0">© <script>document.write(new Date().getFullYear())</script> Unitoreios API   . Develop by Unitoreios </p>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- end auth full page content -->
            </div>
            <!-- end col -->
        </div>
        <!-- end row -->
    </div>
    <!-- end container fluid -->
</div>

<?php include 'layouts/vendor-scripts.php'; ?>
<script src="assets/libs/sweetalert2/sweetalert2.min.js"></script>

<script>
function moveToNext(current, nextFieldID) {
    if (current.value.length >= 1) {
        if(nextFieldID !== current.id) {
            const nextField = document.getElementById('digit'+nextFieldID+'-input');
            if(nextField) nextField.focus();
        }
    }
}

document.getElementById('btn-confirm').addEventListener('click', () => {
    // Lấy 4 số
    let code = '';
    document.querySelectorAll('.digit-input').forEach(input => {
        code += input.value.trim();
    });

    if (code.length !== 4 || !/^\d{4}$/.test(code)) {
        Swal.fire({
            icon: 'error',
            title: 'Lỗi',
            text: 'Vui lòng nhập đầy đủ 4 chữ số hợp lệ.'
        });
        return;
    }

    // Giả lập gửi AJAX lên server kiểm tra
    Swal.fire({
        title: 'Đang xác nhận...',
        didOpen: () => {
            Swal.showLoading();
        },
        allowOutsideClick: false
    });

    // Fake delay 1.5s
    setTimeout(() => {
        Swal.close();

        // Ví dụ kiểm tra mã: giả lập đúng mã là "1234"
        if(code === '1234') {
            Swal.fire({
                icon: 'success',
                title: 'Xác nhận thành công',
                text: 'Email của bạn đã được xác thực.'
            }).then(() => {
                window.location.href = 'home.html'; // chuyển trang sau xác nhận thành công
            });
        } else {
            Swal.fire({
                icon: 'error',
                title: 'Mã không đúng',
                text: 'Mã bạn nhập không chính xác, vui lòng thử lại.'
            });
        }
    }, 1500);
});

// Xử lý gửi lại mã (giả lập)
document.getElementById('resend-code').addEventListener('click', (e) => {
    e.preventDefault();
    Swal.fire({
        title: 'Gửi lại mã',
        text: 'Mã xác thực mới đã được gửi đến email của bạn.',
        icon: 'info',
        timer: 2500,
        showConfirmButton: false
    });
});
</script>

</body>
</html>