<?php
include 'layouts/session_admin.php';
include 'layouts/head-main.php';

if (!isset($_SESSION['email']) || $_SESSION['level'] != 1) {
    header('location: pages-404.php');
    exit;
}

$email = $_SESSION['email'];

// Truy vấn danh sách thông báo
$stmt = $conn->prepare("SELECT * FROM thong_bao ORDER BY id DESC");
$stmt->execute();
$result = $stmt->get_result();
$arrShow = $result->fetch_all(MYSQLI_ASSOC);

// Kiểm tra quyền bằng Prepared Statement
$stmtRole = $conn->prepare("SELECT quyen FROM tai_khoan WHERE email = ?");
$stmtRole->bind_param("s", $email);
$stmtRole->execute();
$resultRole = $stmtRole->get_result();
$rowRole = $resultRole->fetch_assoc();

if (!$rowRole || $rowRole['quyen'] != 1) {
    header('location: logout.php');
    exit;
}
?>
<head>
    <title>List Notification | Unitoreios API APIserie</title>
    <?php include 'layouts/head.php'; ?>
    <link href="assets/libs/flatpickr/flatpickr.min.css" rel="stylesheet" type="text/css">
    <link href="assets/libs/datatables.net-bs4/css/dataTables.bootstrap4.min.css" rel="stylesheet" type="text/css" />
    <link href="assets/libs/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css" rel="stylesheet" type="text/css" />
    <?php include 'layouts/head-style.php'; ?>
</head>

<?php include 'layouts/body.php'; ?>
<div id="layout-wrapper">
    <?php include 'layouts/menu.php'; ?>
    <div class="main-content">
        <div class="page-content">
            <div class="container-fluid">
                <!-- Page Title -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                            <h4 class="mb-sm-0 font-size-18">System Notification</h4>
                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a href="#">Admin</a></li>
                                    <li class="breadcrumb-item active">List notification</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Notifications Table -->
                <div class="row">
                    <div class="col-lg-12">
                        <div class="card">
                            <div class="card-body">
                                <div class="mb-4">
                                    <a href="create-notification.php">
                                        <button type="button" class="btn btn-light waves-effect waves-light">
                                            <i class="bx bx-plus me-1"></i> Thêm thông báo
                                        </button>
                                    </a>
                                </div>

                                <div class="table-responsive">
                                    <table class="table datatable dt-responsive nowrap" style="width: 100%;">
                                        <thead>
                                            <tr>
                                                <th>ID</th>
                                                <th>User</th>
                                                <th>Time</th>
                                                <th>Detail</th>
                                                <th>Type</th>
                                                <th>Edit</th>
                                                <th>Delete</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($arrShow as $arrS): ?>
                                                <tr>
                                                    <td><?= htmlspecialchars($arrS['id']) ?></td>
                                                    <td><?= htmlspecialchars($arrS['noti_user']) ?></td>
                                                    <td><?= htmlspecialchars($arrS['noti_time']) ?></td>
                                                    <td><?= htmlspecialchars($arrS['noti_detail']) ?></td>
                                                    <td>
                                                        <?php
                                                        switch ($arrS['noti_level']) {
                                                            case 0:
                                                                echo '<span class="badge rounded-pill bg-primary">Info</span>';
                                                                break;
                                                            case 1:
                                                                echo '<span class="badge rounded-pill bg-secondary">System</span>';
                                                                break;
                                                            default:
                                                                echo '<span class="badge rounded-pill bg-danger">Caution</span>';
                                                        }
                                                        ?>
                                                    </td>
                                                    <td class="text-center">
                                                        <a href='edit-notification.php?id=<?= $arrS["id"] ?>'>
                                                            <button class='btn btn-soft-light btn-sm w-xs waves-effect'>
                                                                <i class='bx bx-edit'></i> Edit
                                                            </button>
                                                        </a>
                                                    </td>
                                                    <td class="text-center">
                                                        <button onclick='del(<?= $arrS["id"] ?>)' class='btn btn-soft-light btn-sm w-xs waves-effect'>
                                                            <i class='bx bx-trash'></i> Delete
                                                        </button>
                                                    </td>
                                                </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                </div> <!-- table responsive -->
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
        <?php include 'layouts/footer.php'; ?>
    </div>
</div>

<?php include 'layouts/right-sidebar.php'; ?>
<?php include 'layouts/vendor-scripts.php'; ?>

<!-- JS Libraries -->
<script src="assets/libs/flatpickr/flatpickr.min.js"></script>
<script src="assets/libs/datatables.net/js/jquery.dataTables.min.js"></script>
<script src="assets/libs/datatables.net-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="assets/libs/datatables.net-responsive/js/dataTables.responsive.min.js"></script>
<script src="assets/libs/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js"></script>
<script src="assets/js/pages/list-notification.js"></script>
<script src="assets/js/app.js"></script>

<script>
    function del(id) {
        Swal.fire({
            title: 'Xác nhận',
            icon: 'warning',
            text: `Bạn chắc chắn muốn xoá thông báo có ID ${id}?`,
            showCancelButton: true,
            confirmButtonText: "Xác nhận",
        }).then(function(result) {
            if (result.value) {
                $.ajax({
                    url: 'module/ajax-system.php',
                    type: 'POST',
                    dataType: 'JSON',
                    data: {
                        type: 'delnoti',
                        noti_id: id
                    },
                    beforeSend: function() {
                        Swal.fire({
                            title: 'Thông báo',
                            text: 'Vui lòng chờ...',
                            icon: 'info',
                            showConfirmButton: false,
                            allowOutsideClick: false,
                            didOpen: () => Swal.showLoading()
                        });
                    },
                    success: function(data) {
                        if (data.error) {
                            Swal.fire("Lỗi", data.msg, "error");
                        } else {
                            Swal.fire("Thành công", data.msg, "success");
                            setTimeout(() => location.reload(), 1500);
                        }
                    }
                });
            }
        });
    }
</script>
</body>
</html>