<?php include 'layouts/session_admin.php'; ?>
<?php include 'layouts/head-main.php'; ?>
<head>
    <title>Admin Dashboard | Unitoreios</title>
    <?php include 'layouts/head.php'; ?>
    <?php include 'layouts/head-style.php'; ?>
</head>

<?php include 'layouts/body.php'; ?>

<div id="layout-wrapper">

    <?php include 'layouts/menu.php'; ?>

    <div class="main-content">
        <div class="page-content">
            <div class="container-fluid">

                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                            <h4 class="mb-sm-0">Admin Dashboard</h4>
                        </div>
                    </div>
                </div>

                <?php
                // Quick stats
                $st_members = mysqli_fetch_assoc(mysqli_query($conn, "SELECT COUNT(id) AS c FROM tai_khoan"))['c'] ?? 0;
                $st_keys    = mysqli_fetch_assoc(mysqli_query($conn, "SELECT COUNT(id) AS c FROM package_key"))['c'] ?? 0;
                $st_pkgs    = mysqli_fetch_assoc(mysqli_query($conn, "SELECT COUNT(id) AS c FROM package"))['c'] ?? 0;
                $st_devs    = mysqli_fetch_assoc(mysqli_query($conn, "SELECT COUNT(id) AS c FROM devices"))['c'] ?? 0;
                ?>

                <div class="row">
                    <div class="col-md-3">
                        <div class="card"><div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="flex-grow-1">
                                    <p class="text-muted mb-1">Members</p>
                                    <h4 class="mb-0"><?php echo $st_members; ?></h4>
                                </div>
                                <div class="flex-shrink-0"><i data-feather="users"></i></div>
                            </div>
                        </div></div>
                    </div>

                    <div class="col-md-3">
                        <div class="card"><div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="flex-grow-1">
                                    <p class="text-muted mb-1">Keys</p>
                                    <h4 class="mb-0"><?php echo $st_keys; ?></h4>
                                </div>
                                <div class="flex-shrink-0"><i data-feather="key"></i></div>
                            </div>
                        </div></div>
                    </div>

                    <div class="col-md-3">
                        <div class="card"><div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="flex-grow-1">
                                    <p class="text-muted mb-1">Packages</p>
                                    <h4 class="mb-0"><?php echo $st_pkgs; ?></h4>
                                </div>
                                <div class="flex-shrink-0"><i data-feather="package"></i></div>
                            </div>
                        </div></div>
                    </div>

                    <div class="col-md-3">
                        <div class="card"><div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="flex-grow-1">
                                    <p class="text-muted mb-1">Devices</p>
                                    <h4 class="mb-0"><?php echo $st_devs; ?></h4>
                                </div>
                                <div class="flex-shrink-0"><i data-feather="smartphone"></i></div>
                            </div>
                        </div></div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                <h5 class="card-title mb-3">Quick Actions</h5>
                                <div class="d-flex flex-wrap gap-2">
                                    <a class="btn btn-dark" href="tao-package.unitoreios">Tạo Package</a>
                                    <a class="btn btn-dark" href="admin-key.unitoreios">Quản lý Key</a>
                                    <a class="btn btn-dark" href="admin-package.unitoreios">Quản lý Package</a>
                                    <a class="btn btn-dark" href="admin-device.unitoreios">Quản lý Device</a>
                                    <a class="btn btn-dark" href="admin-member.unitoreios">Quản lý Member</a>
                                    <a class="btn btn-dark" href="admin-thong-bao.unitoreios">Thông báo</a>
                                    <a class="btn btn-dark" href="admin-server.unitoreios">Cấu hình Server</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>

        <?php include 'layouts/footer.php'; ?>
    </div>

</div>

<?php include 'layouts/right-sidebar.php'; ?>
<?php include 'layouts/vendor-scripts.php'; ?>
<script>
    feather.replace();
</script>
</body>
</html>
