-- =========================================================
-- Unitoreios API - FULL DATABASE SCHEMA (fresh install)
-- Charset: utf8mb4 (supports Vietnamese + emoji)
-- Import in phpMyAdmin: Database -> Import -> choose this .sql
-- =========================================================

SET NAMES utf8mb4;
SET time_zone = '+07:00';

-- -------------------------
-- Table: websetting (global settings)
-- -------------------------
CREATE TABLE IF NOT EXISTS `websetting` (
  `id` INT(11) NOT NULL,
  `status` TINYINT(1) NOT NULL DEFAULT 1,
  `noti` TEXT NULL,
  `mail` VARCHAR(255) NULL,
  `passmail` VARCHAR(255) NULL,
  `usermail` VARCHAR(255) NULL,
  `casso_api_key` VARCHAR(255) NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Ensure row id=1 exists (code reads websetting WHERE id=1)
INSERT INTO `websetting` (`id`,`status`,`noti`,`mail`,`passmail`,`usermail`,`casso_api_key`)
VALUES (1,1,'',NULL,NULL,NULL,NULL)
ON DUPLICATE KEY UPDATE `id`=`id`;

-- -------------------------
-- Table: tai_khoan (accounts)
-- -------------------------
CREATE TABLE IF NOT EXISTS `tai_khoan` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `username` VARCHAR(32) NOT NULL,
  `email` VARCHAR(255) NOT NULL,
  `mat_khau` VARCHAR(255) NOT NULL,
  `quyen` TINYINT(2) NOT NULL DEFAULT 0,
  `trang_thai` TINYINT(1) NOT NULL DEFAULT 1,
  `truy_cap` INT(11) NOT NULL DEFAULT 0,
  `ngay_tao` DATETIME NULL,
  `token` VARCHAR(255) NULL,

  -- quotas / billing
  `money` INT(11) NOT NULL DEFAULT 0,
  `package_limit` INT(11) NOT NULL DEFAULT 0,
  `keylimit` INT(11) NOT NULL DEFAULT 0,
  `countkey` INT(11) NOT NULL DEFAULT 0,
  `countkeylimit` INT(11) NOT NULL DEFAULT 0,
  `uuid_limit` INT(11) NOT NULL DEFAULT 0,
  `date` DATETIME NULL,

  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_tai_khoan_username` (`username`),
  UNIQUE KEY `uq_tai_khoan_email` (`email`),
  KEY `idx_tai_khoan_quyen` (`quyen`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- -------------------------
-- Table: package (deb packages)
-- -------------------------
CREATE TABLE IF NOT EXISTS `package` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `debname` VARCHAR(255) NOT NULL,
  `debversion` VARCHAR(64) NULL,
  `email` VARCHAR(255) NOT NULL,

  `debstatus` TINYINT(1) NOT NULL DEFAULT 1,
  `debupdatenoti` TEXT NULL,
  `newdeblink` TEXT NULL,
  `debcontact` TEXT NULL,

  `debhash` VARCHAR(255) NOT NULL,
  `colorcode` VARCHAR(32) NULL,

  `statusUDID` TINYINT(1) NOT NULL DEFAULT 1,
  `hashcheck` TINYINT(1) NOT NULL DEFAULT 0,
  `linkmod` TEXT NULL,

  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_package_debhash` (`debhash`),
  KEY `idx_package_email` (`email`),
  CONSTRAINT `fk_package_owner` FOREIGN KEY (`email`) REFERENCES `tai_khoan`(`email`)
    ON UPDATE CASCADE ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- -------------------------
-- Table: package_key (license keys)
-- -------------------------
CREATE TABLE IF NOT EXISTS `package_key` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,

  `package_id` INT(11) NULL,
  `max_uuid` INT(11) NULL DEFAULT 1,

  `devicekey` VARCHAR(255) NOT NULL,
  `datecount` INT(11) NULL DEFAULT 0,
  `date` DATETIME NULL,

  `keytype` INT(11) NULL DEFAULT 4,
  `keystatus` TINYINT(1) NOT NULL DEFAULT 0,

  `email` VARCHAR(255) NULL,

  -- legacy fields used in some endpoints
  `username` VARCHAR(64) NULL,
  `UDID` VARCHAR(255) NULL,
  `status` INT(11) NULL,
  `message` TEXT NULL,

  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_package_key_devicekey` (`devicekey`),
  KEY `idx_package_key_email` (`email`),
  KEY `idx_package_key_package` (`package_id`),
  CONSTRAINT `fk_key_package` FOREIGN KEY (`package_id`) REFERENCES `package`(`id`)
    ON UPDATE CASCADE ON DELETE SET NULL,
  CONSTRAINT `fk_key_owner` FOREIGN KEY (`email`) REFERENCES `tai_khoan`(`email`)
    ON UPDATE CASCADE ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- -------------------------
-- Table: devices (bound devices / UDID)
-- -------------------------
CREATE TABLE IF NOT EXISTS `devices` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `key_id` INT(11) NULL,
  `email` VARCHAR(255) NULL,

  `UDID` VARCHAR(255) NOT NULL,
  `IDREQ` VARCHAR(255) NULL,

  `DEVICE_PRODUCT` VARCHAR(64) NULL,
  `DEVICE_VERSION` VARCHAR(64) NULL,
  `DEVICE_NAME` VARCHAR(128) NULL,

  `status` TINYINT(1) NOT NULL DEFAULT 0,

  -- legacy field (rarely used)
  `devicekey` VARCHAR(255) NULL,

  PRIMARY KEY (`id`),
  KEY `idx_devices_key_id` (`key_id`),
  KEY `idx_devices_email` (`email`),
  KEY `idx_devices_udid` (`UDID`),
  CONSTRAINT `fk_devices_key` FOREIGN KEY (`key_id`) REFERENCES `package_key`(`id`)
    ON UPDATE CASCADE ON DELETE SET NULL,
  CONSTRAINT `fk_devices_owner` FOREIGN KEY (`email`) REFERENCES `tai_khoan`(`email`)
    ON UPDATE CASCADE ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- -------------------------
-- Table: list_uuid (uuid whitelist / per-key)
-- -------------------------
CREATE TABLE IF NOT EXISTS `list_uuid` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `key_id` INT(11) NOT NULL,
  `uuid` VARCHAR(255) NOT NULL,
  `email` VARCHAR(255) NULL,
  PRIMARY KEY (`id`),
  KEY `idx_list_uuid_key_id` (`key_id`),
  UNIQUE KEY `uq_list_uuid_key_uuid` (`key_id`,`uuid`),
  CONSTRAINT `fk_list_uuid_key` FOREIGN KEY (`key_id`) REFERENCES `package_key`(`id`)
    ON UPDATE CASCADE ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- -------------------------
-- Table: thong_bao (admin notifications)
-- -------------------------
CREATE TABLE IF NOT EXISTS `thong_bao` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `noti_user` VARCHAR(255) NULL,
  `noti_detail` TEXT NULL,
  `noti_level` INT(11) NULL DEFAULT 0,
  `created_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_thong_bao_level` (`noti_level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- -------------------------
-- Table: bank_orders (QR orders for auto-approve)
-- -------------------------
CREATE TABLE IF NOT EXISTS `bank_orders` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `email` VARCHAR(255) NOT NULL,
  `plan_code` VARCHAR(32) NOT NULL,
  `amount` INT(11) NOT NULL,
  `content` VARCHAR(255) NOT NULL,
  `status` TINYINT(1) NOT NULL DEFAULT 0,
  `txn_id` VARCHAR(128) NULL,
  `created_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `paid_at` DATETIME NULL,
  PRIMARY KEY (`id`),
  KEY `idx_bank_orders_email` (`email`),
  KEY `idx_bank_orders_status` (`status`),
  KEY `idx_bank_orders_plan` (`plan_code`),
  CONSTRAINT `fk_bank_orders_owner` FOREIGN KEY (`email`) REFERENCES `tai_khoan`(`email`)
    ON UPDATE CASCADE ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- -------------------------
-- Table: bank_transactions (processed txns - anti duplicate)
-- -------------------------
CREATE TABLE IF NOT EXISTS `bank_transactions` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `email` VARCHAR(255) NOT NULL,
  `order_id` INT(11) NULL,
  `plan_code` VARCHAR(32) NOT NULL,
  `amount` INT(11) NOT NULL,
  `content` VARCHAR(255) NOT NULL,
  `txn_id` VARCHAR(128) NOT NULL,
  `created_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_bank_txn_txnid` (`txn_id`),
  KEY `idx_bank_txn_email` (`email`),
  KEY `idx_bank_txn_order` (`order_id`),
  CONSTRAINT `fk_bank_txn_owner` FOREIGN KEY (`email`) REFERENCES `tai_khoan`(`email`)
    ON UPDATE CASCADE ON DELETE CASCADE,
  CONSTRAINT `fk_bank_txn_order` FOREIGN KEY (`order_id`) REFERENCES `bank_orders`(`id`)
    ON UPDATE CASCADE ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- -------------------------
-- Table: getlink (store shortened links)
-- -------------------------
CREATE TABLE IF NOT EXISTS `getlink` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `link` TEXT NOT NULL,
  `id_package` INT(11) NOT NULL,
  `email` VARCHAR(255) NULL,
  `api` TEXT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_getlink_pkg` (`id_package`),
  KEY `idx_getlink_email` (`email`),
  CONSTRAINT `fk_getlink_pkg` FOREIGN KEY (`id_package`) REFERENCES `package`(`id`)
    ON UPDATE CASCADE ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- -------------------------
-- Table: historykey (guest key history)
-- -------------------------
CREATE TABLE IF NOT EXISTS `historykey` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `usernameget` VARCHAR(64) NOT NULL,
  `gettype` INT(11) NOT NULL DEFAULT 0,
  `debid` INT(11) NOT NULL,
  `devicekey` VARCHAR(255) NOT NULL,
  `getip` VARCHAR(64) NULL,
  `created_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_historykey_debid` (`debid`),
  KEY `idx_historykey_usernameget` (`usernameget`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- -------------------------
-- Table: product (posts / marketplace)
-- -------------------------
CREATE TABLE IF NOT EXISTS `product` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `title` VARCHAR(255) NOT NULL,
  `postuser` VARCHAR(64) NOT NULL,
  `postimg` TEXT NULL,
  `postdetail` TEXT NULL,

  `totaltype` VARCHAR(128) NULL,
  `daytotal` VARCHAR(128) NULL,
  `weektotal` VARCHAR(128) NULL,
  `monthtotal` VARCHAR(128) NULL,

  `postdate` VARCHAR(64) NULL,
  `allowgetkey` TINYINT(1) NOT NULL DEFAULT 0,

  `phoneuser` VARCHAR(64) NULL,
  `zalouser` VARCHAR(128) NULL,
  `fbuser` VARCHAR(255) NULL,

  `debid` INT(11) NOT NULL,
  `status` TINYINT(1) NOT NULL DEFAULT 1,
  `deblink` TEXT NULL,

  PRIMARY KEY (`id`),
  KEY `idx_product_postuser` (`postuser`),
  KEY `idx_product_debid` (`debid`),
  CONSTRAINT `fk_product_pkg` FOREIGN KEY (`debid`) REFERENCES `package`(`id`)
    ON UPDATE CASCADE ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- =========================================================
-- OPTIONAL: create an admin account (edit email/password first)
-- INSERT INTO tai_khoan(username,email,mat_khau,quyen,trang_thai,truy_cap,ngay_tao,token)
-- VALUES('admin','admin@example.com','123456',1,1,0,NOW(),SHA2(RAND(),256));
-- =========================================================
