<?php
require_once('layouts/config.php');
date_default_timezone_set('Asia/Ho_Chi_Minh');


if (!isset($_GET['uuid'])) {
    die(json_encode([
        "status" => "error",
        "messenger" => "Thiếu thông tin ID."
    ]));
}

$idreq = $_GET['uuid'];
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta content="width=device-width, initial-scale=1.0" name="viewport">
<title>Get UDID</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/11.0.10/sweetalert2.min.css">
<link rel="shortcut icon" href="assets/images/favicon.ico">
<link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i|Raleway:300,300i,400,400i,500,500i,600,600i,700,700i|Poppins:300,300i,400,400i,500,500i,600,600i,700,700i" rel="stylesheet">

<link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/css/bootstrap.min.css" rel="stylesheet">

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-icons/1.10.5/font/bootstrap-icons.min.css">


<style>
        /*--------------------------------------------------------------
# General
--------------------------------------------------------------*/
body {
  font-family: "Open Sans", sans-serif;
  color: #444444;
  -webkit-font-smoothing: antialiased;
  text-rendering: geometricPrecision;
}

a {
  text-decoration: none;
  color: #5a5af3;
}

a:hover {
  color: #2a2af0;
  text-decoration: none;
}

h1,
h2,
h3,
h4,
h5,
h6 {
  font-family: "Raleway", sans-serif;
}

/*--------------------------------------------------------------
# Header
--------------------------------------------------------------*/
#header {
  transition: all 0.5s;
  z-index: 997;
  padding: 20px 0;
  background: #fff;
}

#header.header-scrolled,
#header.header-inner-pages {
  padding: 12px 0;
  box-shadow: 0px 2px 15px rgba(0, 0, 0, 0.1);
}

#header .logo {
  font-size: 22px;
  margin: 0;
  padding: 0;
  line-height: 1;
  font-weight: 800;
  letter-spacing: 1px;
  text-transform: uppercase;
  font-family: "Poppins", sans-serif;
}

#header .logo a {
  background: linear-gradient(90deg, #5a5af3 0%, #7cdbff 100%);
  -webkit-background-clip: text;
  background-clip: text;
  color: transparent;
  -webkit-text-fill-color: transparent;
}

#header .logo img {
  max-height: 40px;
}

@media (max-width: 992px) {
  #header {
    padding: 12px 0;
  }
  #header .logo {
    font-size: 18px;
    letter-spacing: 0.8px;
  }
}

/*--------------------------------------------------------------
# Hero Section
--------------------------------------------------------------*/
#hero {
  width: 100%;
  height: 100vh;
  background: white;
  border-bottom: 2px solid white;
}

#hero .container {
  padding-top: 80px;
}

#hero h1 {
  margin: 0;
  font-size: 48px;
  font-weight: 400;
  line-height: 56px;
  color: #434175;
  font-family: "Poppins", sans-serif;
}

#hero h2 {
  margin: 10px 0 0 0;
  font-size: 20px;
}

#hero ul {
  margin-top: 15px;
  list-style: none;
  padding: 0;
}

#hero ul li {
  padding: 10px 0 0 28px;
  position: relative;
}

#hero ul i {
  left: 0;
  top: 7px;
  position: absolute;
  font-size: 20px;
  color: #5a5af3;
}

#hero .btn-get-started,
#hero .btn-get-quote {
  font-family: "Poppins", sans-serif;
  font-weight: 400;
  font-size: 15px;
  letter-spacing: 0.5px;
  display: inline-block;
  padding: 8px 30px 9px 30px;
  margin-bottom: 15px;
  border-radius: 3px;
  transition: 0.5s;
  border-radius: 50px;
}

#hero .btn-get-started {
  background: #5a5af3;
  color: #fff;
  border: 2px solid #5a5af3;
  margin-right: 10px;
}

#hero .btn-get-started:hover {
  background: #7272f5;
  border-color: #7272f5;
}

#hero .btn-get-quote {
  color: #5a5af3;
  border: 2px solid #5a5af3;
}

#hero .btn-get-quote:hover {
  background: #5a5af3;
  color: #fff;
}

@media (min-width: 1024px) {
  #hero {
    background-attachment: fixed;
  }
}

@media (max-width: 991px) {
  #hero .hero-img {
    text-align: center;
  }

  #hero .hero-img img {
    width: 50%;
  }
}

@media (max-width: 768px) {
  #hero h1 {
    font-size: 28px;
    line-height: 36px;
  }

  #hero h2 {
    font-size: 18px;
    line-height: 24px;
    margin-bottom: 30px;
  }

  #hero .hero-img img {
    width: 70%;
  }
}

@media (max-width: 575px) {
  #hero {
    text-align: center;
  }

  #hero ul {
    text-align: left;
    font-size: 14px;
  }

  #hero .hero-img img {
    width: 80%;
  }

  #hero .btn-get-started,
  #hero .btn-get-quote {
    padding-left: 18px;
    padding-right: 18px;
    font-size: 14px;
  }
}

/*--------------------------------------------------------------
# Sections General
--------------------------------------------------------------*/
section {
  padding: 60px 0;
}

.section-bg {
  background-color: #eeeef5;
}

.section-title {
  text-align: center;
  padding-bottom: 30px;
}

.section-title h2 {
  font-size: 32px;
  font-weight: bold;
  text-transform: uppercase;
  margin-bottom: 20px;
  padding-bottom: 20px;
  position: relative;
  color: #434175;
}

.section-title h2::after {
  content: "";
  position: absolute;
  display: block;
  width: 50px;
  height: 3px;
  background: #5a5af3;
  bottom: 0;
  left: calc(50% - 25px);
}

.section-title p {
  margin-bottom: 0;
}

/*--------------------------------------------------------------
# Frequently Asked Questions
--------------------------------------------------------------*/
.faq {
  padding: 60px 0;
}

.faq .faq-list {
  padding: 0;
  list-style: none;
}

.faq .faq-list li {
  border-bottom: 1px solid #f2f2fe;
  margin-bottom: 20px;
  padding-bottom: 20px;
}

.faq .faq-list .question {
  display: block;
  position: relative;
  font-family: #5a5af3;
  font-size: 18px;
  line-height: 24px;
  font-weight: 400;
  padding-left: 25px;
  cursor: pointer;
  color: #2a2af0;
  transition: 0.3s;
}

.faq .faq-list i {
  font-size: 16px;
  position: absolute;
  left: 0;
  top: -2px;
}

.faq .faq-list p {
  margin-bottom: 0;
  padding: 10px 0 0 25px;
}

.faq .faq-list .icon-show {
  display: none;
}

.faq .faq-list .collapsed {
  color: black;
}

.faq .faq-list .collapsed:hover {
  color: #5a5af3;
}

.faq .faq-list .collapsed .icon-show {
  display: inline-block;
  transition: 0.6s;
}

.faq .faq-list .collapsed .icon-close {
  display: none;
  transition: 0.6s;
}

/*--------------------------------------------------------------
# Footer
--------------------------------------------------------------*/
#footer {
  color: #444444;
  font-size: 14px;
  background: #eeeef5;
  box-shadow: 0px 2px 15px rgba(0, 0, 0, 0.1);
}

#footer .footer-top {
  padding: 60px 0 30px 0;
  background: #fff;
}

#footer .footer-top .footer-contact {
  margin-bottom: 30px;
}

#footer .footer-top .footer-contact h3 {
  font-size: 28px;
  margin: 0 0 10px 0;
  padding: 0;
  line-height: 1;
  font-weight: 700;
  color: #5a5af3;
}

#footer .footer-top .footer-contact p {
  font-size: 14px;
  line-height: 24px;
  margin-bottom: 0;
  font-family: "Raleway", sans-serif;
  color: #777777;
}

#footer .footer-top h4 {
  font-size: 16px;
  font-weight: bold;
  color: #434175;
  position: relative;
  padding-bottom: 12px;
}

#footer .footer-top .footer-links {
  margin-bottom: 30px;
}

#footer .footer-top .footer-links ul {
  list-style: none;
  padding: 0;
  margin: 0;
}

#footer .footer-top .footer-links ul i {
  padding-right: 2px;
  color: #5a5af3;
  font-size: 18px;
  line-height: 1;
}

#footer .footer-top .footer-links ul li {
  padding: 10px 0;
  display: flex;
  align-items: center;
}

#footer .footer-top .footer-links ul li:first-child {
  padding-top: 0;
}

#footer .footer-top .footer-links ul a {
  color: #777777;
  transition: 0.3s;
  display: inline-block;
  line-height: 1;
}

#footer .footer-top .footer-links ul a:hover {
  text-decoration: none;
  color: #5a5af3;
}

#footer .footer-newsletter {
  font-size: 15px;
}

#footer .footer-newsletter h4 {
  font-size: 16px;
  font-weight: bold;
  color: #444444;
  position: relative;
  padding-bottom: 12px;
}

#footer .footer-newsletter form {
  margin-top: 30px;
  background: #fff;
  padding: 6px 10px;
  position: relative;
  border-radius: 50px;
  text-align: left;
  border: 1px solid #b9b9fa;
}

#footer .footer-newsletter form input[type="email"] {
  border: 0;
  padding: 4px 8px;
  width: calc(100% - 100px);
}

#footer .footer-newsletter form input[type="submit"] {
  position: absolute;
  top: -1px;
  right: -1px;
  bottom: -1px;
  border: 0;
  background: none;
  font-size: 16px;
  padding: 0 20px;
  background: #5a5af3;
  color: #fff;
  transition: 0.3s;
  border-radius: 50px;
  box-shadow: 0px 2px 15px rgba(0, 0, 0, 0.1);
}

#footer .footer-newsletter form input[type="submit"]:hover {
  background: #7272f5;
}

#footer .credits {
  padding-top: 5px;
  font-size: 13px;
  color: #444444;
}

#footer .credits a {
  transition: 0.3s;
}

#footer .social-links a {
  font-size: 18px;
  display: inline-block;
  background: #deddec;
  color: #434175;
  line-height: 1;
  padding: 8px 0;
  margin-right: 4px;
  border-radius: 50%;
  text-align: center;
  width: 36px;
  height: 36px;
  transition: 0.3s;
}

#footer .social-links a:hover {
  background: #5a5af3;
  color: #fff;
  text-decoration: none;
}

    </style>
</head>
<body>

<header id="header" class="fixed-top ">
<div class="container d-flex align-items-center justify-content-between">
<h1 class="logo"><a href="#">UNITORE API SERVER</a></h1>
</div>
</header>

<section id="hero" class="d-flex align-items-center">
<div class="container">
<div class="row">
<div class="col-lg-12 pt-2 pt-lg-0 order-2 order-lg-1 d-flex flex-column justify-content-center">
<h1>Get UDID Tool</h1>
<ul>
<li><i class="bi bi-check"></i> When the installation mobileconfig file is authorized to obtain UDID, if the password is prompted, it is your lock screen password</li>
<li><i class="bi bi-check"></i> The mobileconfig file install path is Settings-General-Device Management</li>
<li><i class="bi bi-check"></i> If the install time is too long or the install fail, please return to the App directly</li>
</ul>
<div class="mt-3">
<button onclick="getUDID()" class="btn-get-started">Get UDID</button>
</div>
</div>
</div>
</div>
</section>
<main id="main">
<section id="faq" class="faq">
<div class="container">
<div class="section-title">
<h2>Câu hỏi thường gặp</h2>
</div>
<ul class="faq-list">
<li>
<div data-bs-toggle="collapse" class="collapsed question" href="#faq1">Xuất hiện lỗi "Cấu hình không hợp lệ" <i class="bi bi-chevron-down icon-show"></i><i class="bi bi-chevron-up icon-close"></i></div>
<div id="faq1" class="collapse" data-bs-parent=".faq-list">
<p>
Lỗi này do quá trình sign chứng chỉ SSL của chúng tôi đã hết hạn, bạn hãy vào "Cài đặt" tìm profile vừa tải để cài thủ công và thông báo lại cho Admin.
</p>
</div>
</li>
<li>
<div data-bs-toggle="collapse" href="#faq2" class="collapsed question">Xuất hiện lỗi "Thiết bị chưa được kích hoạt" <i class="bi bi-chevron-down icon-show"></i><i class="bi bi-chevron-up icon-close"></i></div>
<div id="faq2" class="collapse" data-bs-parent=".faq-list">
<p>
Máy bị khoá iCloud và sử dụng tool bypass không hỗ trợ Apple Service thì không thể thực hiện lấy UDID qua cách này. Hãy bypass lại máy bằng tool trả phí để máy trong trạng thái kích hoạt.
</p>
</div>
</li>
<li>
<div data-bs-toggle="collapse" href="#faq3" class="collapsed question">Quá trình tải trang quá lâu <i class="bi bi-chevron-down icon-show"></i><i class="bi bi-chevron-up icon-close"></i></div>
<div id="faq3" class="collapse" data-bs-parent=".faq-list">
<p>
Vì trong quá trình load trang web, chúng tôi phải thực hiện sign chứng chỉ SSL vào mobileconfig cho thiết bị của bạn. Trong thời gian cao điểm, việc ký hàng loạt chứng chỉ có thể gây nghẽn nên bạn hãy kiên nhẫn chờ đợi và không cố load lại trang vì bạn sẽ phải đợi lâu hơn.
</p>
</div>
</li>
<li>
<div data-bs-toggle="collapse" href="#faq4" class="collapsed question">Bảo mật và quyền riêng tư <i class="bi bi-chevron-down icon-show"></i><i class="bi bi-chevron-up icon-close"></i></div>
<div id="faq4" class="collapse" data-bs-parent=".faq-list">
<p>
Công cụ được tạo và quản lý bởi hệ thống Unitoreios API. Các thông tin được lấy được bao gồm UDID và phiên bản iOS đều được sử dụng với mục đích xác minh các ứng dụng sử dụng API Key của Unitoreios API và không sử dụng vào mục đích nào khác.
</p>
</div>
</li>
</ul>
</div>
</section>
</main>

<footer id="footer">
<div class="container d-md-flex py-4">
<div class="me-md-auto text-center text-md-start">
<div class="copyright">
&copy; Copyright <strong><span>Unitoreios API</span></strong>. All Rights Reserved
</div>
</div>
<div class="social-links text-center text-md-right pt-3 pt-md-0">
<a href="https://t.me/unitoreios" target="_blank" class="twitter"><i class="bi bi-github"></i></a>
<a href="https://unitoreios.com/dashboard" target="_blank" class="facebook"><i class="bi bi-facebook"></i></a>
<a href="https://t.me/unitoreios" target="_blank" class="linkedin"><i class="bi bi-telegram"></i></a>
</div>
</div>
</footer>

<script src="https://code.jquery.com/jquery-3.6.4.min.js" integrity="sha256-oP6HI9z1XaZNBrJURtCoUT5SUnxFr8s3BzRl+cbzUq8=" crossorigin="anonymous"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/js/bootstrap.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/11.0.10/sweetalert2.min.js"></script>

<script>
    const idRequest = <?=json_encode($idreq)?>;
    
    function getUDID() {
    var baseUrl = window.location.origin + window.location.pathname.replace(/\/[^\/]*$/, "");
    $.ajax({
        url: baseUrl + "/get_mobileconfig.php",
        type: "POST",
        dataType: "JSON",
        timeout: 60000,
        data: { id: idRequest },
        beforeSend: function () {
            Swal.fire({
                title: "UDID Processing",
                text: "Please wait...",
                icon: "info",
                showConfirmButton: false,
                allowOutsideClick: false,
                timerProgressBar: true,
                didOpen: () => {
                    Swal.showLoading()
                }
            });
        },
        error: (xhr, status, err) => {
            // Important: without this, the loading popup will stay forever.
            Swal.fire({
                icon: "error",
                title: "Error",
                text: (xhr && xhr.responseJSON && xhr.responseJSON.message) ? xhr.responseJSON.message : ("Request timeout / server error (" + (xhr ? xhr.status : "") + ")."),
            });
        },
        success: (response) => {
            if (response.error) {
                Swal.fire("Error", response.message || "Can't create mobileconfig for device. Contact admin for issue", "error");
            } else {
                Swal.fire({
                    icon: "success",
                    title: "UDID Tool",
                    text: response.message || "Create mobileconfig successfully. Please allow and install config.",
                    showDenyButton: true,
                    showCancelButton: false,
                    confirmButtonText: "Go to setting",
                    denyButtonText: "Reload mobileconfig"
                }).then((result) => {
                    if (result.isConfirmed) {
                        window.location.href = response.mobileconfig;
                    } else if (result.isDenied) {
                        getUDID();
                    }
                });
                setTimeout(() => {
                    window.location.href = response.mobileconfig;

                    // Cleanup old profiles later (avoid deleting the file while Safari is still downloading)
                    setTimeout(() => {
                        $.ajax({
                            url: baseUrl + "/2.php",
                            type: "POST",
                            dataType: "JSON",
                            data: { keep: response.mobileconfig },
                        });
                    }, 20000);
                }, 500);
            }
        }
    });
}


</script>

</body>
</html>
