<?php
require_once('layouts/config.php');
require_once('layouts/unitoreios_crypto.php');

function encryptAES($data, $key, $iv) {
    return openssl_encrypt($data, 'aes-256-cbc', $key, 0, $iv);
}
function sendResponse($data) {
    $response = json_encode($data, JSON_UNESCAPED_UNICODE);
    $response = encryptAES($response, UNITOREIOS_AES_KEY, UNITOREIOS_AES_IV);
    die($response);
}

$hash = isset($_GET['hash']) ? trim($_GET['hash']) : '';
$uuid = isset($_GET['uuid']) ? trim($_GET['uuid']) : '';

if ($hash === '' || $uuid === '') {
    sendResponse([
        'error' => true,
        'messenger' => 'Thiếu tham số (hash/uuid).',
        'data' => []
    ]);
}

// Lấy package theo debhash
$stmt = mysqli_prepare($conn, "SELECT id, email, statusUDID FROM package WHERE debhash = ? LIMIT 1");
mysqli_stmt_bind_param($stmt, "s", $hash);
mysqli_stmt_execute($stmt);
$package = u_stmt_fetch_assoc($stmt);

if (!$package) {
    sendResponse([
        'error' => true,
        'messenger' => 'Gói Package không tồn tại hoặc đã bị xóa.',
        'data' => []
    ]);
}

$statusUDID = isset($package['statusUDID']) ? intval($package['statusUDID']) : 1;

// Nếu package không yêu cầu UDID
if ($statusUDID === 0) {
    sendResponse([
        'error' => false,
        'messenger' => 'OK',
        'data' => [
            'statusUDID' => 0,
            'udid' => '',
            'keyUDID' => ''
        ]
    ]);
}

// Lấy UDID theo IDREQ (uuid)
$stmt2 = mysqli_prepare($conn, "SELECT UDID FROM devices WHERE IDREQ = ? LIMIT 1");
mysqli_stmt_bind_param($stmt2, "s", $uuid);
mysqli_stmt_execute($stmt2);
$row2 = u_stmt_fetch_assoc($stmt2);
mysqli_stmt_close($stmt2);

$udid = ($row2 && !empty($row2['UDID'])) ? $row2['UDID'] : '';

if ($udid === '') {
    // Chưa có UDID: client cần gọi get_mobileconfig -> install -> processes_data
    sendResponse([
        'error' => false,
        'messenger' => 'Cần UDID',
        'data' => [
            'statusUDID' => 1,
            'udid' => '',
            'keyUDID' => ''
        ]
    ]);
}

// Lấy keyUDID dựa theo email package + UDID
$keyUDID = '';
$stmt3 = mysqli_prepare($conn, "SELECT pk.devicekey 
    FROM devices d 
    JOIN package_key pk ON pk.id = d.key_id
    WHERE d.UDID = ? AND d.email = ? 
    ORDER BY pk.id DESC LIMIT 1");
mysqli_stmt_bind_param($stmt3, "ss", $udid, $package['email']);
mysqli_stmt_execute($stmt3);
$row3 = u_stmt_fetch_assoc($stmt3);
mysqli_stmt_close($stmt3);
if ($row3 && !empty($row3['devicekey'])) {
    $keyUDID = $row3['devicekey'];
}

sendResponse([
    'error' => false,
    'messenger' => 'OK',
    'data' => [
        'statusUDID' => 1,
        'udid' => $udid,
        'keyUDID' => $keyUDID
    ]
]);
?>
