<?php
require_once('layouts/config.php');
require_once('layouts/unitoreios_crypto.php');
date_default_timezone_set('Asia/Ho_Chi_Minh');

// ---  Cấu hình mã hóa  ---
$aesKey = UNITOREIOS_AES_KEY; // Khóa AES
$aesIv = UNITOREIOS_AES_IV; // IV cho AES 
$desKey = 'your_secret_des_key';  // Khóa DES, **THAY THẾ BẰNG KHÓA BÍ MẬT CỦA BẠN!** 

// --- Hàm mã hóa --- 

function encryptAES($data, $key, $iv) {
    return openssl_encrypt($data, 'aes-256-cbc', $key, 0, $iv);
}

function encryptDES($data, $key) {
    $cipherMethod = 'des-cbc';
    $iv = openssl_random_pseudo_bytes(openssl_cipher_iv_length($cipherMethod));
    $encrypted = openssl_encrypt($data, $cipherMethod, $key, OPENSSL_RAW_DATA, $iv);
    return base64_encode($iv . $encrypted);
}

function isEncryptionEnabled() {
    return true; // Bật mã hóa 
}

function sendResponse($data, $aesKey, $aesIv, $desKey) {
    $response = json_encode($data);
    if (isEncryptionEnabled()) {
        $response = encryptAES($response, $aesKey, $aesIv);
        $response = encryptDES($response, $desKey);
        $response = base64_encode($response);
    }
    die($response);
}

// ---  Xử lý request  ---

if (!isset($_GET['key']) || !isset($_GET['udid']) || !isset($_GET['hash'])) {
    $data1 = [
        "trangthaikey" => "error",
        "messenger" => "Không Tồn Tại!"
    ];
    sendResponse($data1, $aesKey, $aesIv, $desKey);
}

$hash = $_GET['hash'];
$key = $_GET['key'];
$udid = $_GET['udid'];
$uuid = $_GET['uuid'];

$package = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM `package` WHERE `debhash` = '$hash'"));

if (!$package) {
    $data2 = [
        "trangthaikey" => "error",
        "messenger" => "Gói Package không tồn tại hoặc đã bị xóa."
    ];
    sendResponse($data2, $aesKey, $aesIv, $desKey); 
}

if ($package['debstatus'] == 2) {
    $data3 = [
        "trangthaikey" => "error",
        "messenger" => "Gói Package Hiện Đang Bảo Trì Để Nâng Cấp Vui Lòng Vào Lại Sau Ít Phút!"
    ];
    sendResponse($data3, $aesKey, $aesIv, $desKey); 
}

$key = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM `package_key` WHERE `devicekey` = '$key' AND `package_id` = '" . $package['id'] . "' "));

if (!$key) {
    $data4 = [
        "trangthaikey" => "error",
        "messenger" => "Key Không Hợp Lệ! Liên Hệ ADMIN Để Nhận Key"
    ];
    sendResponse($data4, $aesKey, $aesIv, $desKey);
}

// Lấy số lượng UDID đã sử dụng key
$sql_udid = mysqli_num_rows(mysqli_query($conn, "SELECT * FROM `devices` WHERE `key_id` = '" . $key['id'] . "' "));

if ($key['keystatus'] == 0) {
    if ($key['max_uuid'] > $sql_udid) {
        // Kiểm tra UDID
        $checkUdidQuery = mysqli_query($conn, "SELECT * FROM `devices` WHERE `UDID` = '$udid'");

        if (mysqli_num_rows($checkUdidQuery) > 0) {
            $existingDevice = mysqli_fetch_assoc($checkUdidQuery);
            if (!empty($existingDevice['email'])) {
                mysqli_query($conn, "INSERT INTO devices(key_id, IDREQ, UDID, email) VALUES('" . $key['id'] . "', '$uuid', '$udid', '" . $key['email'] . "')");
            } else {
                mysqli_query($conn, "UPDATE `devices` SET `key_id` = '" . $key['id'] . "', `email` = '" . $key['email'] . "' WHERE `IDREQ` = '$uuid'");
            }
        }

        $dateCount = $key['datecount'];
        $newDate = date('Y-m-d H:i:s', strtotime('+' . $dateCount . ' days'));
        mysqli_query($conn, "UPDATE `package_key` SET `date`='$newDate', `keystatus`='1' WHERE `id`='" . $key['id'] . "'");

        $key = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM `package_key` WHERE `id` = '" . $key['id'] . "' "));

        $end = new DateTime($key['date']); 
    } else {
        $data5 = [
            "trangthaikey" => "error",
            "messenger" => "Bạn không Có Quyền Truy Cập Key Này!"
        ];
        sendResponse($data5, $aesKey, $aesIv, $desKey); 
    }
} else {
    $end = new DateTime($key['date']);
}

$uuid2 = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM `devices` WHERE `UDID` = '$udid' AND `key_id` = '" . $key['id'] . "' "));

if (!$uuid2) {
    if ($key['max_uuid'] > $sql_udid) {
        $existingDevice = mysqli_fetch_assoc($checkUdidQuery);
        if (!empty($existingDevice['email'])) {
            mysqli_query($conn, "INSERT INTO devices(key_id, IDREQ, UDID, email) VALUES('" . $key['id'] . "', '$uuid', '$udid', '" . $key['email'] . "')");
        } else {
            mysqli_query($conn, "UPDATE `devices` SET `key_id` = '" . $key['id'] . "', `email` = '" . $key['email'] . "' WHERE `IDREQ` = '$uuid'");
        }
    } else {
        $data6 = [
            "trangthaikey" => "error",
            "messenger" => "Bạn Không Thể Truy Cập Key Này Nữa! Đã Đến Giới Hạn Của Key"
        ];
        sendResponse($data6, $aesKey, $aesIv, $desKey); 
    }
}

mysqli_query($conn, "UPDATE `devices` SET `key_id` = '" . $key['id'] . "', `email` = '" . $key['email'] . "' WHERE `IDREQ` = '$uuid'");

$udid = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM `devices` WHERE `UDID` = '$udid' AND `email` = '" . $key['email'] . "' "));

if ($udid['status'] == 1) {
    $data7 = [
        "trangthaikey" => "error",
        "messenger" => "Máy Của Bạn Bị Khóa Không Thể Sử Dụng Key Này!"
    ];
    sendResponse($data7, $aesKey, $aesIv, $desKey); 
}

$hienntai = new DateTime();
$thoi_gian_truc_tiep = $hienntai->format('Y-m-d H:i:s'); 

if ($end < $hienntai) { 
    $data8 = [
        "trangthaikey" => "error", 
        "messenger" => "Key Hết Hạn! Hãy Liên Hệ Unitoreios Để Gia Hạn Và Tiếp Tục Sử Dụng!",
        "time" => $thoi_gian_truc_tiep 
    ];
    sendResponse($data8, $aesKey, $aesIv, $desKey);
} else {
    $interval = $end->diff($hienntai);
    $remainingSeconds = $interval->days * 24 * 60 * 60 + $interval->h * 60 * 60 + $interval->i * 60 + $interval->s;
    $jsonData = [
        "trangthaikey" => "successfully", 
        "key" => $key['devicekey'], 
        "encypttimerkey" => ($remainingSeconds) . " KEY By unitoreios",
        "UDID" => $udid['UDID'], 
        "timer" => $thoi_gian_truc_tiep
    ];
    sendResponse($jsonData, $aesKey, $aesIv, $desKey);
} 
?>