<?php
require_once('layouts/config.php');
require_once('layouts/unitoreios_crypto.php');
date_default_timezone_set('Asia/Ho_Chi_Minh');

function encryptAES($data, $key, $iv) {
    return openssl_encrypt($data, 'aes-256-cbc', $key, 0, $iv);
}

function isEncryptionEnabled() {
    // Chỉnh sửa 'false' để tắt mã hóa "true" để bật
    return true;
}

function sendResponse($data, $key, $iv) {
    $response = json_encode($data);
    if (isEncryptionEnabled()) {
        $response = encryptAES($response, $key, $iv);
    }
    die($response);
}

if (!isset($_GET['key']) || !isset($_GET['udid']) || !isset($_GET['hash'])) {
    $data1 = [
        "trangthaikey" => "error",
        "messenger" => "Không Tồn Tại!"
    ];
    sendResponse($data1, UNITOREIOS_AES_KEY, UNITOREIOS_AES_IV);
}

$hash = $_GET['hash'];
$key = $_GET['key'];
$udid = $_GET['udid'];
$uuid = isset($_GET['uuid']) ? $_GET['uuid'] : null;

$package_query = "SELECT * FROM `package` WHERE `debhash` = '$hash'";
$package_result = mysqli_query($conn, $package_query);
if (!$package_result) {
    error_log("Error executing query: " . mysqli_error($conn));
    http_response_code(500);
    exit;
}
$package = mysqli_fetch_assoc($package_result);

if (!$package) {
    $data2 = [
        "trangthaikey" => "error",
        "messenger" => "Gói Package không tồn tại hoặc đã bị xóa."
    ];
    sendResponse($data2, UNITOREIOS_AES_KEY, UNITOREIOS_AES_IV);
}

if ($package['debstatus'] == 2) {
    $data3 = [
        "trangthaikey" => "error",
        "messenger" => "Gói Package Hiện Đang Bảo Trì Để Nâng Cấp Vui Lòng Vào Lại Sau Ít Phút!"
    ];
    sendResponse($data3, UNITOREIOS_AES_KEY, UNITOREIOS_AES_IV);
}

$key_query = "SELECT * FROM `package_key` WHERE `devicekey` = '$key' AND `package_id` = '" . $package['id'] . "' ";
$key_result = mysqli_query($conn, $key_query);
if (!$key_result) {
    error_log("Error executing query: " . mysqli_error($conn));
    http_response_code(500);
    exit;
}
$key = mysqli_fetch_assoc($key_result);

if (!$key) {
    $data4 = [
        "trangthaikey" => "error",
        "messenger" => "Key Không Hợp Lệ! Liên Hệ ADMIN Để Nhận Key"
    ];
    sendResponse($data4, UNITOREIOS_AES_KEY, UNITOREIOS_AES_IV);
}

// Lấy số lượng UDID đã sử dụng key
$sql_udid_query = "SELECT * FROM `devices` WHERE `key_id` = '" . $key['id'] . "' ";
$sql_udid_result = mysqli_query($conn, $sql_udid_query);
if (!$sql_udid_result) {
    error_log("Error executing query: " . mysqli_error($conn));
    http_response_code(500);
    exit;
}
$sql_udid = mysqli_num_rows($sql_udid_result);

if ($key['keystatus'] == 0) {
    if ($key['max_uuid'] > $sql_udid) {
        // Kiểm tra UDID
        $checkUdidQuery = "SELECT * FROM `devices` WHERE `UDID` = '$udid'";
        $checkUdidResult = mysqli_query($conn, $checkUdidQuery);
        if (!$checkUdidResult) {
            error_log("Error executing query: " . mysqli_error($conn));
            http_response_code(500);
            exit;
        }

        if (mysqli_num_rows($checkUdidResult) > 0) {
            // UDID đã tồn tại, kiểm tra xem đã có email hay chưa
            $existingDevice = mysqli_fetch_assoc($checkUdidResult);
            if (!empty($existingDevice['email'])) {
                // Đã có email, thêm mới một dòng khác
                $insertDeviceQuery = "INSERT INTO devices(key_id, IDREQ, UDID, email) VALUES('" . $key['id'] . "', '$uuid', '$udid', '" . $key['email'] . "')";
                if (!mysqli_query($conn, $insertDeviceQuery)) {
                    error_log("Error executing query: " . mysqli_error($conn));
                    http_response_code(500);
                    exit;
                }
            } else {
                // Chưa có email, cập nhật email cho dòng hiện tại
                $updateDeviceQuery = "UPDATE `devices` SET `key_id` = '" . $key['id'] . "', `email` = '" . $key['email'] . "' WHERE `IDREQ` = '$uuid'";
                if (!mysqli_query($conn, $updateDeviceQuery)) {
                    error_log("Error executing query: " . mysqli_error($conn));
                    http_response_code(500);
                    exit;
                }
            }
        } else {
            // Nếu UDID chưa tồn tại, thêm mới
            $insertDeviceQuery = "INSERT INTO devices(key_id, IDREQ, UDID, email) VALUES('" . $key['id'] . "', '$uuid', '$udid', '" . $key['email'] . "')";
            if (!mysqli_query($conn, $insertDeviceQuery)) {
                error_log("Error executing query: " . mysqli_error($conn));
                http_response_code(500);
                exit;
            }
        }

        // Cập nhật ngày hết hạn và trạng thái key
        $dateCount = $key['datecount'];
        $newDate = date('Y-m-d H:i:s', strtotime('+' . $dateCount . ' days'));
        $updateKeyQuery = "UPDATE `package_key` SET `date`='$newDate', `keystatus`='1' WHERE `id`='" . $key['id'] . "'";
        if (!mysqli_query($conn, $updateKeyQuery)) {
            error_log("Error executing query: " . mysqli_error($conn));
            http_response_code(500);
            exit;
        }

        // Lấy lại thông tin key sau khi cập nhật
        $key_query = "SELECT * FROM `package_key` WHERE `id` = '" . $key['id'] . "' ";
        $key_result = mysqli_query($conn, $key_query);
        if (!$key_result) {
            error_log("Error executing query: " . mysqli_error($conn));
            http_response_code(500);
            exit;
        }
        $key = mysqli_fetch_assoc($key_result);

        // Lấy ngày hết hạn
        $end = new DateTime($key['date']);
    } else {
        // Trả về lỗi nếu vượt quá giới hạn UDID
        $data5 = [
            "trangthaikey" => "error",
            "messenger" => "Bạn không Có Quyền Truy Cập Key Này!"
        ];
        sendResponse($data5, UNITOREIOS_AES_KEY, UNITOREIOS_AES_IV);
    }
} else {
    // Key đã được sử dụng, lấy ngày hết hạn
    $end = new DateTime($key['date']);
}

$uuid2_query = "SELECT * FROM `devices` WHERE `UDID` = '$udid' AND `key_id` = '" . $key['id'] . "'";
$uuid2_result = mysqli_query($conn, $uuid2_query);
if (!$uuid2_result) {
    error_log("Error executing query: " . mysqli_error($conn));
    http_response_code(500);
    exit;
}
$uuid2 = mysqli_fetch_assoc($uuid2_result);

if (!$uuid2) {
    if ($key['max_uuid'] > $sql_udid) {
        $insertDeviceQuery = "INSERT INTO devices(key_id, IDREQ, UDID, email) VALUES('" . $key['id'] . "', '$uuid', '$udid', '" . $key['email'] . "')";
        if (!mysqli_query($conn, $insertDeviceQuery)) {
            error_log("Error executing query: " . mysqli_error($conn));
            http_response_code(500);
            exit;
        }
    } else {
        $data6 = [
            "trangthaikey" => "error",
            "messenger" => "Bạn Không Thể Truy Cập Key Này Nữa! Đã Đến Giới Hạn Của Key"
        ];
        sendResponse($data6, UNITOREIOS_AES_KEY, UNITOREIOS_AES_IV);
    }
}

$udid_query = "SELECT * FROM `devices` WHERE `UDID` = '$udid' AND `email` = '" . $key['email'] . "' ";
$udid_result = mysqli_query($conn, $udid_query);
if (!$udid_result) {
    error_log("Error executing query: " . mysqli_error($conn));
    http_response_code(500);
    exit;
}
$udidRecord = mysqli_fetch_assoc($udid_result);

if ($udidRecord['status'] == 1) {
    $data7 = [
        "trangthaikey" => "error",
        "messenger" => "Máy Của Bạn Bị Khóa Không Thể Sử Dụng Key Này!"
    ];
    sendResponse($data7, UNITOREIOS_AES_KEY, UNITOREIOS_AES_IV);
}

$hienntai = new DateTime();
$thoi_gian_truc_tiep = $hienntai->format('Y-m-d H:i:s');

if ($end < $hienntai) {
    $data8 = [
        "trangthaikey" => "error",
        "messenger" => "Key Hết Hạn! Hãy Liên Hệ Unitoreios Để Gia Hạn Và Tiếp Tục Sử Dụng!",
        "time" => $thoi_gian_truc_tiep
    ];
    sendResponse($data8, UNITOREIOS_AES_KEY, UNITOREIOS_AES_IV);
} else {
    $interval = $end->diff($hienntai);
    $remainingSeconds = $interval->days * 24 * 60 * 60 + $interval->h * 60 * 60 + $interval->i * 60 + $interval->s;

    $jsonData = [
        "trangthaikey" => "successfully",
        "key" => $key['devicekey'],
        "encypttimerkey" => ($remainingSeconds) . " KEY By unitoreios",
        "UDID" => $udidRecord['UDID'],
        "timer" => $thoi_gian_truc_tiep
    ];
    sendResponse($jsonData, UNITOREIOS_AES_KEY, UNITOREIOS_AES_IV);
}
?>
